/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.routine.ir;

import io.trino.sql.relational.RowExpression;
import io.trino.sql.routine.ir.IrBlock;
import io.trino.sql.routine.ir.IrBreak;
import io.trino.sql.routine.ir.IrContinue;
import io.trino.sql.routine.ir.IrIf;
import io.trino.sql.routine.ir.IrLoop;
import io.trino.sql.routine.ir.IrNodeVisitor;
import io.trino.sql.routine.ir.IrRepeat;
import io.trino.sql.routine.ir.IrReturn;
import io.trino.sql.routine.ir.IrRoutine;
import io.trino.sql.routine.ir.IrSet;
import io.trino.sql.routine.ir.IrStatement;
import io.trino.sql.routine.ir.IrVariable;
import io.trino.sql.routine.ir.IrWhile;

public class DefaultIrNodeVisitor
implements IrNodeVisitor<Void, Void> {
    @Override
    public Void visitRoutine(IrRoutine node, Void context) {
        for (IrVariable parameter : node.parameters()) {
            this.process(parameter, context);
        }
        this.process(node.body(), context);
        return null;
    }

    @Override
    public Void visitVariable(IrVariable node, Void context) {
        this.visitRowExpression(node.defaultValue());
        return null;
    }

    @Override
    public Void visitBlock(IrBlock node, Void context) {
        for (IrVariable variable : node.variables()) {
            this.process(variable, context);
        }
        for (IrStatement statement : node.statements()) {
            this.process(statement, context);
        }
        return null;
    }

    @Override
    public Void visitBreak(IrBreak node, Void context) {
        return null;
    }

    @Override
    public Void visitContinue(IrContinue node, Void context) {
        return null;
    }

    @Override
    public Void visitIf(IrIf node, Void context) {
        this.visitRowExpression(node.condition());
        this.process(node.ifTrue(), context);
        if (node.ifFalse().isPresent()) {
            this.process(node.ifFalse().get(), context);
        }
        return null;
    }

    @Override
    public Void visitWhile(IrWhile node, Void context) {
        this.visitRowExpression(node.condition());
        this.process(node.body(), context);
        return null;
    }

    @Override
    public Void visitRepeat(IrRepeat node, Void context) {
        this.visitRowExpression(node.condition());
        this.process(node.block(), context);
        return null;
    }

    @Override
    public Void visitLoop(IrLoop node, Void context) {
        this.process(node.block(), context);
        return null;
    }

    @Override
    public Void visitReturn(IrReturn node, Void context) {
        this.visitRowExpression(node.value());
        return null;
    }

    @Override
    public Void visitSet(IrSet node, Void context) {
        this.visitRowExpression(node.value());
        this.process(node.target(), context);
        return null;
    }

    public void visitRowExpression(RowExpression expression) {
    }
}

