/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.routine.ir;

import com.google.common.collect.ImmutableList;
import io.trino.sql.routine.ir.IrLabel;
import io.trino.sql.routine.ir.IrNodeVisitor;
import io.trino.sql.routine.ir.IrStatement;
import io.trino.sql.routine.ir.IrVariable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record IrBlock(Optional<IrLabel> label, List<IrVariable> variables, List<IrStatement> statements) implements IrStatement
{
    public IrBlock(List<IrVariable> variables, List<IrStatement> statements) {
        this(Optional.empty(), variables, statements);
    }

    public IrBlock {
        Objects.requireNonNull(label, "label is null");
        variables = ImmutableList.copyOf((Collection)Objects.requireNonNull(variables, "variables is null"));
        statements = ImmutableList.copyOf((Collection)Objects.requireNonNull(statements, "statements is null"));
    }

    @Override
    public <C, R> R accept(IrNodeVisitor<C, R> visitor, C context) {
        return visitor.visitBlock(this, context);
    }
}

