/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.client.StatementStats;
import io.trino.client.Warning;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.testing.MaterializedRow;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MaterializedResult
implements Iterable<MaterializedRow> {
    public static final int DEFAULT_PRECISION = 5;
    private final List<MaterializedRow> rows;
    private final List<Type> types;
    private final List<String> columnNames;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;
    private final Optional<String> updateType;
    private final OptionalLong updateCount;
    private final List<Warning> warnings;
    private final Optional<StatementStats> statementStats;

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types) {
        this(rows, types, Optional.empty());
    }

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types, Optional<List<String>> columnNames) {
        this(rows, types, columnNames.orElse((List<String>)ImmutableList.of()), (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), OptionalLong.empty(), (List<Warning>)ImmutableList.of(), Optional.empty());
    }

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types, List<String> columnNames, Map<String, String> setSessionProperties, Set<String> resetSessionProperties, Optional<String> updateType, OptionalLong updateCount, List<Warning> warnings, Optional<StatementStats> statementStats) {
        this.rows = ImmutableList.copyOf((Collection)Objects.requireNonNull(rows, "rows is null"));
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.setSessionProperties = ImmutableMap.copyOf(Objects.requireNonNull(setSessionProperties, "setSessionProperties is null"));
        this.resetSessionProperties = ImmutableSet.copyOf((Collection)Objects.requireNonNull(resetSessionProperties, "resetSessionProperties is null"));
        this.updateType = Objects.requireNonNull(updateType, "updateType is null");
        this.updateCount = Objects.requireNonNull(updateCount, "updateCount is null");
        this.warnings = Objects.requireNonNull(warnings, "warnings is null");
        this.statementStats = Objects.requireNonNull(statementStats, "statementStats is null");
    }

    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<MaterializedRow> iterator() {
        return this.rows.iterator();
    }

    public List<MaterializedRow> getMaterializedRows() {
        return this.rows;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<String> getColumnNames() {
        Preconditions.checkState((!this.columnNames.isEmpty() ? 1 : 0) != 0, (Object)"Column names are unknown");
        return this.columnNames;
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public Optional<String> getUpdateType() {
        return this.updateType;
    }

    public OptionalLong getUpdateCount() {
        return this.updateCount;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public Optional<StatementStats> getStatementStats() {
        return this.statementStats;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedResult o = (MaterializedResult)obj;
        return Objects.equals(this.types, o.types) && Objects.equals(this.rows, o.rows) && Objects.equals(this.setSessionProperties, o.setSessionProperties) && Objects.equals(this.resetSessionProperties, o.resetSessionProperties) && Objects.equals(this.updateType, o.updateType) && Objects.equals(this.updateCount, o.updateCount);
    }

    public int hashCode() {
        return Objects.hash(this.rows, this.types, this.setSessionProperties, this.resetSessionProperties, this.updateType, this.updateCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rows", this.rows).add("types", this.types).add("setSessionProperties", this.setSessionProperties).add("resetSessionProperties", this.resetSessionProperties).add("updateType", this.updateType.orElse(null)).add("updateCount", this.updateCount.isPresent() ? Long.valueOf(this.updateCount.getAsLong()) : null).omitNullValues().toString();
    }

    public MaterializedResult exceptColumns(String ... columnNamesToExclude) {
        this.validateIfColumnsPresent(columnNamesToExclude);
        Preconditions.checkArgument((columnNamesToExclude.length > 0 ? 1 : 0) != 0, (Object)"At least one column must be excluded");
        Preconditions.checkArgument((columnNamesToExclude.length < this.getColumnNames().size() ? 1 : 0) != 0, (Object)"All columns cannot be excluded");
        return this.projected(((Predicate<String>)Set.of(columnNamesToExclude)::contains).negate());
    }

    public MaterializedResult project(String ... columnNamesToInclude) {
        this.validateIfColumnsPresent(columnNamesToInclude);
        Preconditions.checkArgument((columnNamesToInclude.length > 0 ? 1 : 0) != 0, (Object)"At least one column must be projected");
        return this.projected(Set.of(columnNamesToInclude)::contains);
    }

    private void validateIfColumnsPresent(String ... columns) {
        ImmutableSet columnNames = ImmutableSet.copyOf(this.getColumnNames());
        for (String column : columns) {
            Preconditions.checkArgument((boolean)columnNames.contains(column), (Object)"[%s] column is not present in %s".formatted(column, columnNames));
        }
    }

    private MaterializedResult projected(Predicate<String> columnFilter) {
        List<String> columnNames = this.getColumnNames();
        HashMap<Integer, String> columnsIndexToNameMap = new HashMap<Integer, String>();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            if (!columnFilter.test(columnName)) continue;
            columnsIndexToNameMap.put(i, columnName);
        }
        return new MaterializedResult((List)this.getMaterializedRows().stream().map(row -> new MaterializedRow(row.getPrecision(), columnsIndexToNameMap.keySet().stream().map(row::getField).collect(Collectors.toList()))).collect(ImmutableList.toImmutableList()), (List)columnsIndexToNameMap.keySet().stream().map(this.getTypes()::get).collect(ImmutableList.toImmutableList()));
    }

    public Stream<Object> getOnlyColumn() {
        Preconditions.checkState((this.types.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one column");
        return this.rows.stream().map(row -> row.getField(0));
    }

    public Set<Object> getOnlyColumnAsSet() {
        return this.getOnlyColumn().collect(Collectors.toSet());
    }

    public Object getOnlyValue() {
        Preconditions.checkState((this.rows.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one row");
        Preconditions.checkState((this.types.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one column");
        return this.rows.get(0).getField(0);
    }

    public MaterializedResult toTestTypes() {
        return new MaterializedResult((List)this.rows.stream().map(MaterializedResult::convertToTestTypes).collect(ImmutableList.toImmutableList()), this.types, this.columnNames, this.setSessionProperties, this.resetSessionProperties, this.updateType, this.updateCount, this.warnings, this.statementStats);
    }

    private static MaterializedRow convertToTestTypes(MaterializedRow trinoRow) {
        ArrayList<Object> convertedValues = new ArrayList<Object>();
        for (int field = 0; field < trinoRow.getFieldCount(); ++field) {
            Object convertedValue;
            Object trinoValue = trinoRow.getField(field);
            if (trinoValue instanceof SqlDate) {
                convertedValue = LocalDate.ofEpochDay(((SqlDate)trinoValue).getDays());
            } else if (trinoValue instanceof SqlTime) {
                convertedValue = DateTimeFormatter.ISO_LOCAL_TIME.parse((CharSequence)trinoValue.toString(), LocalTime::from);
            } else if (trinoValue instanceof SqlTimeWithTimeZone) {
                long nanos = Timestamps.roundDiv((long)((SqlTimeWithTimeZone)trinoValue).getPicos(), (long)1000L);
                int offsetMinutes = ((SqlTimeWithTimeZone)trinoValue).getOffsetMinutes();
                convertedValue = OffsetTime.of(LocalTime.ofNanoOfDay(nanos), ZoneOffset.ofTotalSeconds(offsetMinutes * 60));
            } else {
                convertedValue = trinoValue instanceof SqlTimestamp ? ((SqlTimestamp)trinoValue).toLocalDateTime() : (trinoValue instanceof SqlTimestampWithTimeZone ? ((SqlTimestampWithTimeZone)trinoValue).toZonedDateTime() : (trinoValue instanceof SqlDecimal ? ((SqlDecimal)trinoValue).toBigDecimal() : trinoValue));
            }
            convertedValues.add(convertedValue);
        }
        return new MaterializedRow(trinoRow.getPrecision(), convertedValues);
    }

    public static MaterializedResult materializeSourceDataStream(ConnectorSession session, ConnectorPageSource pageSource, List<Type> types) {
        Builder builder = MaterializedResult.resultBuilder(session, types);
        while (!pageSource.isFinished()) {
            Page outputPage = pageSource.getNextPage();
            if (outputPage == null) continue;
            builder.page(outputPage);
        }
        return builder.build();
    }

    public static Builder resultBuilder(Session session, Type ... types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(Session session, Iterable<? extends Type> types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(ConnectorSession session, Type ... types) {
        return MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)ImmutableList.copyOf((Object[])types));
    }

    public static Builder resultBuilder(ConnectorSession session, Iterable<? extends Type> types) {
        return new Builder(session, (List<Type>)ImmutableList.copyOf(types));
    }

    public static class Builder {
        private final ConnectorSession session;
        private final List<Type> types;
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();
        private Optional<List<String>> columnNames = Optional.empty();

        Builder(ConnectorSession session, List<Type> types) {
            this.session = session;
            this.types = ImmutableList.copyOf(types);
        }

        public synchronized Builder rows(List<MaterializedRow> rows) {
            this.rows.addAll(rows);
            return this;
        }

        public synchronized Builder row(Object ... values) {
            this.rows.add((Object)new MaterializedRow(5, values));
            return this;
        }

        public synchronized Builder rows(Object[][] rows) {
            for (Object[] row : rows) {
                this.row(row);
            }
            return this;
        }

        public synchronized Builder pages(Iterable<Page> pages) {
            for (Page page : pages) {
                this.page(page);
            }
            return this;
        }

        public synchronized Builder page(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.types.size() ? 1 : 0) != 0, (String)"Expected a page with %s columns, but got %s columns", (int)this.types.size(), (int)page.getChannelCount());
            for (int position = 0; position < page.getPositionCount(); ++position) {
                ArrayList<Object> values = new ArrayList(page.getChannelCount());
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    Type type = this.types.get(channel);
                    Block block = page.getBlock(channel);
                    values.add(type.getObjectValue(this.session, block, position));
                }
                values = Collections.unmodifiableList(values);
                this.rows.add((Object)new MaterializedRow(5, values));
            }
            return this;
        }

        public synchronized Builder columnNames(List<String> columnNames) {
            this.columnNames = Optional.of(ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null")));
            return this;
        }

        public synchronized MaterializedResult build() {
            return new MaterializedResult((List<MaterializedRow>)this.rows.build(), this.types, this.columnNames);
        }
    }
}

