/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.type.CharType;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeParameter;
import java.util.List;

public class CharParametricType
implements ParametricType {
    public static final CharParametricType CHAR = new CharParametricType();

    public String getName() {
        return "char";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return CharType.createCharType((int)1);
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected at most one parameter for CHAR");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("CHAR length must be a number");
        }
        long length = parameter.getLongLiteral();
        if (length < 0L || length > 65536L) {
            throw new IllegalArgumentException("Invalid CHAR length " + length);
        }
        return CharType.createCharType((int)Math.toIntExact(length));
    }
}

