/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import java.util.stream.DoubleStream;

public final class MoreMath {
    private MoreMath() {
    }

    public static boolean nearlyEqual(double a, double b, double epsilon) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || diff < Double.MIN_NORMAL) {
            return diff < epsilon * Double.MIN_NORMAL;
        }
        return diff / Math.min(absA + absB, Double.MAX_VALUE) < epsilon;
    }

    public static boolean nearlyEqual(float a, float b, float epsilon) {
        float absA = Math.abs(a);
        float absB = Math.abs(b);
        float diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0f || b == 0.0f || diff < Float.MIN_NORMAL) {
            return diff < epsilon * Float.MIN_NORMAL;
        }
        return diff / Math.min(absA + absB, Float.MAX_VALUE) < epsilon;
    }

    public static double min(double ... values) {
        return DoubleStream.of(values).min().getAsDouble();
    }

    public static double max(double ... values) {
        return DoubleStream.of(values).max().getAsDouble();
    }

    public static double rangeMin(double left, double right) {
        if (Double.isNaN(left)) {
            return right;
        }
        if (Double.isNaN(right)) {
            return left;
        }
        return MoreMath.min(left, right);
    }

    public static double rangeMax(double left, double right) {
        if (Double.isNaN(left)) {
            return right;
        }
        if (Double.isNaN(right)) {
            return left;
        }
        return MoreMath.max(left, right);
    }

    public static double firstNonNaN(double ... values) {
        for (double value : values) {
            if (Double.isNaN(value)) continue;
            return value;
        }
        throw new IllegalArgumentException("All values are NaN");
    }

    public static double averageExcludingNaNs(double first, double second) {
        if (Double.isNaN(first) && Double.isNaN(second)) {
            return Double.NaN;
        }
        if (!Double.isNaN(first) && !Double.isNaN(second)) {
            return (first + second) / 2.0;
        }
        return MoreMath.firstNonNaN(first, second);
    }

    public static double minExcludeNaN(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return MoreMath.min(v1, v2);
    }

    public static double maxExcludeNaN(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return MoreMath.max(v1, v2);
    }

    public static int previousPowerOfTwo(int x) {
        return Math.max(1, 1 << 31 - Integer.numberOfLeadingZeros(x));
    }
}

