/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.codec;

import com.google.common.base.MoreObjects;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.Transport;
import java.util.Objects;

public class FrameInfo {
    private final String methodName;
    private final byte messageType;
    private final int sequenceId;
    private final Transport transport;
    private final Protocol protocol;
    private final boolean supportOutOfOrderResponse;

    public FrameInfo(String methodName, byte messageType, int sequenceId, Transport transport, Protocol protocol, boolean supportOutOfOrderResponse) {
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.messageType = messageType;
        this.sequenceId = sequenceId;
        this.transport = Objects.requireNonNull(transport, "transport is null");
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
        this.supportOutOfOrderResponse = supportOutOfOrderResponse;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean isSupportOutOfOrderResponse() {
        return this.supportOutOfOrderResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameInfo that = (FrameInfo)o;
        return this.messageType == that.messageType && this.sequenceId == that.sequenceId && this.supportOutOfOrderResponse == that.supportOutOfOrderResponse && Objects.equals(this.methodName, that.methodName) && this.transport == that.transport && this.protocol == that.protocol;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.methodName, this.messageType, this.sequenceId, this.transport, this.protocol, this.supportOutOfOrderResponse});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("methodName", (Object)this.methodName).add("messageType", (int)this.messageType).add("sequenceId", this.sequenceId).add("transport", (Object)this.transport).add("protocol", (Object)this.protocol).add("supportOutOfOrderResponse", this.supportOutOfOrderResponse).toString();
    }
}

