/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import com.google.common.io.CharStreams;
import io.airlift.bytecode.AddFakeLineNumberClassVisitor;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ClassInfoLoader;
import io.airlift.bytecode.CompilationException;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.SmartClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

class ByteCodeGenerator {
    private final boolean fakeLineNumbers;
    private final ClassLoader runAsmVerifierClassLoader;
    private final boolean dumpRawBytecode;
    private final Writer output;
    private final Optional<Path> dumpClassPath;

    public static ByteCodeGenerator byteCodeGenerator() {
        return new ByteCodeGenerator(false, null, false, CharStreams.nullWriter(), Optional.empty());
    }

    private ByteCodeGenerator(boolean fakeLineNumbers, ClassLoader runAsmVerifierClassLoader, boolean dumpRawBytecode, Writer output, Optional<Path> dumpClassPath) {
        this.fakeLineNumbers = fakeLineNumbers;
        this.runAsmVerifierClassLoader = runAsmVerifierClassLoader;
        this.dumpRawBytecode = dumpRawBytecode;
        this.output = Objects.requireNonNull(output, "output is null");
        this.dumpClassPath = Objects.requireNonNull(dumpClassPath, "dumpClassPath is null");
    }

    public ByteCodeGenerator fakeLineNumbers(boolean fakeLineNumbers) {
        return new ByteCodeGenerator(fakeLineNumbers, this.runAsmVerifierClassLoader, this.dumpRawBytecode, this.output, this.dumpClassPath);
    }

    public ByteCodeGenerator runAsmVerifier(ClassLoader runAsmVerifierClassLoader) {
        return new ByteCodeGenerator(this.fakeLineNumbers, runAsmVerifierClassLoader, this.dumpRawBytecode, this.output, this.dumpClassPath);
    }

    public ByteCodeGenerator dumpRawBytecode(boolean dumpRawBytecode) {
        return new ByteCodeGenerator(this.fakeLineNumbers, this.runAsmVerifierClassLoader, dumpRawBytecode, this.output, this.dumpClassPath);
    }

    public ByteCodeGenerator outputTo(Writer output) {
        return new ByteCodeGenerator(this.fakeLineNumbers, this.runAsmVerifierClassLoader, this.dumpRawBytecode, output, this.dumpClassPath);
    }

    public ByteCodeGenerator dumpClassFilesTo(Optional<Path> dumpClassPath) {
        return new ByteCodeGenerator(this.fakeLineNumbers, this.runAsmVerifierClassLoader, this.dumpRawBytecode, this.output, dumpClassPath);
    }

    public byte[] generateByteCode(ClassInfoLoader classInfoLoader, ClassDefinition classDefinition) {
        byte[] bytecode;
        SmartClassWriter writer = new SmartClassWriter(classInfoLoader);
        try {
            classDefinition.visit((ClassVisitor)(this.fakeLineNumbers ? new AddFakeLineNumberClassVisitor((ClassVisitor)writer) : writer));
        }
        catch (IndexOutOfBoundsException | NegativeArraySizeException e) {
            StringWriter out = new StringWriter();
            classDefinition.visit((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), new PrintWriter(out)));
            throw new IllegalArgumentException("Error processing class definition:\n" + out, e);
        }
        try {
            bytecode = writer.toByteArray();
        }
        catch (RuntimeException e) {
            throw new CompilationException("Error compiling class: " + classDefinition.getName(), e);
        }
        this.dumpClassPath.ifPresent(path -> {
            String className = classDefinition.getType().getJavaClassName();
            String name = ParameterizedType.typeFromJavaClassName(className).getClassName() + ".class";
            Path file = path.resolve(name).toAbsolutePath();
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, bytecode, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write generated class file: " + file, e);
            }
        });
        if (this.dumpRawBytecode) {
            ClassReader classReader = new ClassReader(bytecode);
            classReader.accept((ClassVisitor)new TraceClassVisitor(new PrintWriter(this.output)), 8);
        }
        if (this.runAsmVerifierClassLoader != null) {
            ClassReader reader = new ClassReader(bytecode);
            CheckClassAdapter.verify((ClassReader)reader, (ClassLoader)this.runAsmVerifierClassLoader, (boolean)true, (PrintWriter)new PrintWriter(this.output));
        }
        return bytecode;
    }
}

