/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.codec.metadata.Extractor;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ReflectionHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class MethodExtractor
extends Extractor {
    private final Type thriftStructType;
    private final Method method;

    public MethodExtractor(Type thriftStructType, Method method, ThriftField annotation, FieldKind fieldKind) {
        super(annotation, fieldKind);
        this.thriftStructType = thriftStructType;
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String extractName() {
        return ReflectionHelper.extractFieldName(this.method.getName());
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.method.getGenericReturnType());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", (Object)this.method).toString();
    }
}

