/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch.statistics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.tpch.statistics.ColumnStatisticsData;
import io.trino.plugin.tpch.statistics.TableStatisticsData;
import io.trino.plugin.tpch.statistics.TableStatisticsDataRepository;
import io.trino.plugin.tpch.util.Optionals;
import io.trino.plugin.tpch.util.Types;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StatisticsEstimator {
    private final TableStatisticsDataRepository tableStatisticsDataRepository;

    public StatisticsEstimator(TableStatisticsDataRepository tableStatisticsDataRepository) {
        this.tableStatisticsDataRepository = tableStatisticsDataRepository;
    }

    public Optional<TableStatisticsData> estimateStats(TpchTable<?> tpchTable, Map<TpchColumn<?>, List<Object>> columnValuesRestrictions, double scaleFactor) {
        String schemaName = "sf" + scaleFactor;
        if (columnValuesRestrictions.isEmpty()) {
            return this.tableStatisticsDataRepository.load(schemaName, tpchTable, Optional.empty(), Optional.empty());
        }
        if (columnValuesRestrictions.values().stream().allMatch(List::isEmpty)) {
            return Optional.of(this.zeroStatistics(tpchTable));
        }
        Preconditions.checkArgument((columnValuesRestrictions.size() <= 1 ? 1 : 0) != 0, (Object)"Can only estimate stats when at most one column has value restrictions");
        TpchColumn partitionColumn = (TpchColumn)Iterables.getOnlyElement(columnValuesRestrictions.keySet());
        List<Object> partitionValues = columnValuesRestrictions.get(partitionColumn);
        TableStatisticsData result = this.zeroStatistics(tpchTable);
        for (Object partitionValue : partitionValues) {
            Slice value = Types.checkType(partitionValue, Slice.class, "Only string (Slice) partition values supported for now", new Object[0]);
            Optional<TableStatisticsData> tableStatisticsData = this.tableStatisticsDataRepository.load(schemaName, tpchTable, Optional.of(partitionColumn), Optional.of(value.toStringUtf8()));
            if (tableStatisticsData.isEmpty()) {
                return Optional.empty();
            }
            result = this.addPartitionStats(result, tableStatisticsData.get(), partitionColumn);
        }
        return Optional.of(result);
    }

    private TableStatisticsData addPartitionStats(TableStatisticsData left, TableStatisticsData right, TpchColumn<?> partitionColumn) {
        Map combinedColumnStats = (Map)left.columns().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            String columnName = (String)entry.getKey();
            ColumnStatisticsData leftStats = (ColumnStatisticsData)entry.getValue();
            ColumnStatisticsData rightStats = right.columns().get(columnName);
            Optional<Long> ndv = this.addDistinctValuesCount(partitionColumn, columnName, leftStats, rightStats);
            Optional<Object> min = Optionals.combine(leftStats.min(), rightStats.min(), this::min);
            Optional<Object> max = Optionals.combine(leftStats.max(), rightStats.max(), this::max);
            Optional<Long> dataSize = leftStats.dataSize().flatMap(leftDataSize -> rightStats.dataSize().map(rightDataSize -> leftDataSize + rightDataSize));
            return new ColumnStatisticsData(ndv, min, max, dataSize);
        }));
        return new TableStatisticsData(left.rowCount() + right.rowCount(), combinedColumnStats);
    }

    private Optional<Long> addDistinctValuesCount(TpchColumn<?> partitionColumn, String columnName, ColumnStatisticsData leftStats, ColumnStatisticsData rightStats) {
        return Optionals.combine(leftStats.distinctValuesCount(), rightStats.distinctValuesCount(), Long::sum).filter(v -> columnName.equals(partitionColumn.getColumnName()));
    }

    private Object min(Object l, Object r) {
        Types.checkSameType(l, r);
        Comparable left = Types.checkType(l, Comparable.class);
        Comparable right = Types.checkType(r, Comparable.class);
        return left.compareTo(right) < 0 ? left : right;
    }

    private Object max(Object l, Object r) {
        Types.checkSameType(l, r);
        Comparable left = Types.checkType(l, Comparable.class);
        Comparable right = Types.checkType(r, Comparable.class);
        return left.compareTo(right) > 0 ? left : right;
    }

    private TableStatisticsData zeroStatistics(TpchTable<?> table) {
        return new TableStatisticsData(0L, (Map)table.getColumns().stream().collect(ImmutableMap.toImmutableMap(TpchColumn::getColumnName, column -> ColumnStatisticsData.zero())));
    }
}

