/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.model.ContainerNetwork;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.testcontainers.containers.ContainerDef;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.shaded.com.trilead.ssh2.Connection;
import org.testcontainers.utility.DockerImageName;

public enum PortForwardingContainer {
    INSTANCE;

    private static String PASSWORD;
    private static ContainerDef DEFINITION;
    private GenericContainer<?> container;
    private final Set<Map.Entry<Integer, Integer>> exposedPorts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicReference<Object> sshConnection = new AtomicReference();

    private Connection createSSHSession() {
        this.container = new GenericContainer(DEFINITION);
        this.container.start();
        Connection connection = new Connection(this.container.getHost(), this.container.getMappedPort(22));
        connection.setTCPNoDelay(true);
        connection.connect((hostname, port, serverHostKeyAlgorithm, serverHostKey) -> true, (int)Duration.ofSeconds(30L).toMillis(), (int)Duration.ofSeconds(30L).toMillis());
        if (!connection.authenticateWithPassword("root", PASSWORD)) {
            throw new IllegalStateException("Authentication failed.");
        }
        return connection;
    }

    public void exposeHostPort(int port) {
        this.exposeHostPort(port, port);
    }

    public void exposeHostPort(int hostPort, int containerPort) {
        if (this.exposedPorts.add(new AbstractMap.SimpleEntry<Integer, Integer>(hostPort, containerPort))) {
            this.getSshConnection().requestRemotePortForwarding("", containerPort, "localhost", hostPort);
        }
    }

    void start() {
        this.getSshConnection();
    }

    Optional<ContainerNetwork> getNetwork() {
        return Optional.ofNullable(this.container).map(GenericContainer::getContainerInfo).flatMap(it -> it.getNetworkSettings().getNetworks().values().stream().findFirst());
    }

    void reset() {
        if (this.container != null) {
            this.container.stop();
        }
        this.container = null;
        this.sshConnection.set(null);
        this.exposedPorts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getSshConnection() {
        Object value = this.sshConnection.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.sshConnection;
            synchronized (atomicReference) {
                value = this.sshConnection.get();
                if (value == null) {
                    Connection actualValue = this.createSSHSession();
                    value = actualValue == null ? this.sshConnection : actualValue;
                    this.sshConnection.set(value);
                }
            }
        }
        return (Connection)(value == this.sshConnection ? null : value);
    }

    static {
        PASSWORD = UUID.randomUUID().toString();
        DEFINITION = new ContainerDef(){
            {
                this.setImage(DockerImageName.parse("testcontainers/sshd:1.2.0"));
                this.addExposedTcpPort(22);
                this.addEnvVar("PASSWORD", PASSWORD);
            }
        };
    }
}

