/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.IntArrayBlockBuilder;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIntArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Integer[] expectedValues = TestIntArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestIntArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Integer[] expectedValues = TestIntArrayBlock.alternatingNullValues(TestIntArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestIntArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Integer[] expectedValues = TestIntArrayBlock.createTestValue(100);
        IntArrayBlockBuilder emptyBlockBuilder = new IntArrayBlockBuilder(null, 0);
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestIntArrayBlock.writeValues(expectedValues, blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = (IntArrayBlockBuilder)blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        BlockBuilder blockBuilder = TestIntArrayBlock.createBlockBuilderWithValues(TestIntArrayBlock.createTestValue(100));
        Block block = blockBuilder.build();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo(4L);
        }
        Assertions.assertThat((long)new IntArrayBlockBuilder(null, 22).appendNull().build().getEstimatedDataSizeForStats(0)).isEqualTo(0L);
    }

    @Test
    public void testCompactBlock() {
        int[] intArray = new int[]{0, 0, 1, 2, 3, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestIntArrayBlock.testCompactBlock((Block)new IntArrayBlock(0, Optional.empty(), new int[0]));
        TestIntArrayBlock.testCompactBlock((Block)new IntArrayBlock(intArray.length, Optional.of(valueIsNull), intArray));
        TestIntArrayBlock.testNotCompactBlock((Block)new IntArrayBlock(intArray.length - 1, Optional.of(valueIsNull), intArray));
    }

    private void assertFixedWithValues(Integer[] expectedValues) {
        Block block = TestIntArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Integer[] expectedValues) {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, expectedValues.length);
        TestIntArrayBlock.writeValues(expectedValues, blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Integer[] expectedValues, IntArrayBlockBuilder blockBuilder) {
        for (Integer expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeInt(expectedValue.intValue());
        }
    }

    private static Integer[] createTestValue(int positionCount) {
        Integer[] expectedValues = new Integer[positionCount];
        Random random = new Random(0L);
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = random.nextInt();
        }
        return expectedValues;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        Assertions.assertThat((int)((IntArrayBlock)block).getInt(position)).isEqualTo(((Integer)expectedValue).intValue());
    }
}

