/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ShortArrayBlock;
import io.trino.spi.block.ShortArrayBlockBuilder;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestShortArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Short[] expectedValues = TestShortArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestShortArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Short[] expectedValues = TestShortArrayBlock.alternatingNullValues(TestShortArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestShortArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Short[] expectedValues = TestShortArrayBlock.createTestValue(100);
        ShortArrayBlockBuilder emptyBlockBuilder = new ShortArrayBlockBuilder(null, 0);
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestShortArrayBlock.writeValues(expectedValues, blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = (ShortArrayBlockBuilder)blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        BlockBuilder blockBuilder = TestShortArrayBlock.createBlockBuilderWithValues(TestShortArrayBlock.createTestValue(100));
        Block block = blockBuilder.build();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo(2L);
        }
        Assertions.assertThat((long)new ShortArrayBlockBuilder(null, 22).appendNull().build().getEstimatedDataSizeForStats(0)).isEqualTo(0L);
    }

    @Test
    public void testCompactBlock() {
        short[] shortArray = new short[]{0, 0, 1, 2, 3, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestShortArrayBlock.testCompactBlock((Block)new ShortArrayBlock(0, Optional.empty(), new short[0]));
        TestShortArrayBlock.testCompactBlock((Block)new ShortArrayBlock(shortArray.length, Optional.of(valueIsNull), shortArray));
        TestShortArrayBlock.testNotCompactBlock((Block)new ShortArrayBlock(shortArray.length - 1, Optional.of(valueIsNull), shortArray));
    }

    private void assertFixedWithValues(Short[] expectedValues) {
        Block block = TestShortArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Short[] expectedValues) {
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, expectedValues.length);
        TestShortArrayBlock.writeValues(expectedValues, blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Short[] expectedValues, ShortArrayBlockBuilder blockBuilder) {
        for (Short expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeShort(expectedValue.shortValue());
        }
    }

    private static Short[] createTestValue(int positionCount) {
        Short[] expectedValues = new Short[positionCount];
        Random random = new Random(0L);
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = (short)random.nextInt();
        }
        return expectedValues;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        Assertions.assertThat((short)((ShortArrayBlock)block).getShort(position)).isEqualTo(((Short)expectedValue).shortValue());
    }
}

