/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVariableWidthBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        this.assertVariableWithValues(expectedValues);
        this.assertVariableWithValues(TestVariableWidthBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyRegion() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        Block block = TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues).build();
        Block actual = block.copyRegion(10, 10);
        Block expected = TestVariableWidthBlock.createBlockBuilderWithValues(Arrays.copyOfRange(expectedValues, 10, 20)).build();
        Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.getPositionCount());
        Assertions.assertThat((long)actual.getSizeInBytes()).isEqualTo(expected.getSizeInBytes());
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestVariableWidthBlock.alternatingNullValues(TestVariableWidthBlock.createExpectedValues(100));
        BlockBuilder blockBuilder = TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), new int[0]);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 1, 2, 3, 7, 8, 9, 10, 11, 50);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 7, 6, 6, 50, 11, 50);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        VariableWidthBlockBuilder emptyBlockBuilder = new VariableWidthBlockBuilder(null, 0, 0);
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, expectedValues.length, 32 * expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestVariableWidthBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testGetSizeInBytes() {
        int numEntries = 1000;
        VarcharType unboundedVarcharType = VarcharType.createUnboundedVarcharType();
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, numEntries, 20 * numEntries);
        for (int i = 0; i < numEntries; ++i) {
            unboundedVarcharType.writeString((BlockBuilder)blockBuilder, String.valueOf(ThreadLocalRandom.current().nextLong()));
        }
        Block block = blockBuilder.build();
        List<Block> splitQuarter = TestVariableWidthBlock.splitBlock(block, 4);
        long sizeInBytes = block.getSizeInBytes();
        long quarter1size = splitQuarter.get(0).getSizeInBytes();
        long quarter2size = splitQuarter.get(1).getSizeInBytes();
        long quarter3size = splitQuarter.get(2).getSizeInBytes();
        long quarter4size = splitQuarter.get(3).getSizeInBytes();
        double expectedQuarterSizeMin = (double)sizeInBytes * 0.2;
        double expectedQuarterSizeMax = (double)sizeInBytes * 0.3;
        ((AbstractBooleanAssert)Assertions.assertThat(((double)quarter1size > expectedQuarterSizeMin && (double)quarter1size < expectedQuarterSizeMax ? 1 : 0) != 0).describedAs(String.format("quarter1size is %s, should be between %s and %s", quarter1size, expectedQuarterSizeMin, expectedQuarterSizeMax), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat(((double)quarter2size > expectedQuarterSizeMin && (double)quarter2size < expectedQuarterSizeMax ? 1 : 0) != 0).describedAs(String.format("quarter2size is %s, should be between %s and %s", quarter2size, expectedQuarterSizeMin, expectedQuarterSizeMax), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat(((double)quarter3size > expectedQuarterSizeMin && (double)quarter3size < expectedQuarterSizeMax ? 1 : 0) != 0).describedAs(String.format("quarter3size is %s, should be between %s and %s", quarter3size, expectedQuarterSizeMin, expectedQuarterSizeMax), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat(((double)quarter4size > expectedQuarterSizeMin && (double)quarter4size < expectedQuarterSizeMax ? 1 : 0) != 0).describedAs(String.format("quarter4size is %s, should be between %s and %s", quarter4size, expectedQuarterSizeMin, expectedQuarterSizeMax), new Object[0])).isTrue();
        Assertions.assertThat((long)(quarter1size + quarter2size + quarter3size + quarter4size)).isEqualTo(sizeInBytes);
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        TestVariableWidthBlock.assertEstimatedDataSizeForStats(TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        Slice compactSlice = TestVariableWidthBlock.createExpectedValue(16).copy();
        Slice incompactSlice = TestVariableWidthBlock.createExpectedValue(20).copy().slice(0, 16);
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestVariableWidthBlock.testCompactBlock((Block)new VariableWidthBlock(0, Slices.EMPTY_SLICE, new int[1], Optional.empty()));
        TestVariableWidthBlock.testCompactBlock((Block)new VariableWidthBlock(valueIsNull.length, compactSlice, offsets, Optional.of(valueIsNull)));
        TestVariableWidthBlock.testNotCompactBlock((Block)new VariableWidthBlock(valueIsNull.length - 1, compactSlice, offsets, Optional.of(valueIsNull)));
        TestVariableWidthBlock.testNotCompactBlock((Block)new VariableWidthBlock(valueIsNull.length, incompactSlice, offsets, Optional.of(valueIsNull)));
    }

    private void assertVariableWithValues(Slice[] expectedValues) {
        Block block = TestVariableWidthBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, expectedValues.length, 32 * expectedValues.length);
        return TestVariableWidthBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
    }

    private static BlockBuilder writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            ((VariableWidthBlockBuilder)blockBuilder).writeEntry(expectedValue);
        }
        return blockBuilder;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        Assertions.assertThat((Comparable)((VariableWidthBlock)block).getSlice(position)).isEqualTo(expectedValue);
    }
}

