/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.EstimateAssertion;
import io.trino.cost.SymbolStatsEstimate;
import java.util.Objects;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;

public class SymbolStatsAssertion {
    private final SymbolStatsEstimate statistics;

    private SymbolStatsAssertion(SymbolStatsEstimate statistics) {
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public static SymbolStatsAssertion assertThat(SymbolStatsEstimate actual) {
        return new SymbolStatsAssertion(actual);
    }

    public SymbolStatsAssertion nullsFraction(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getNullsFraction(), expected, "nullsFraction mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion nullsFractionUnknown() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Double.isNaN(this.statistics.getNullsFraction())).describedAs("expected unknown nullsFraction but got " + this.statistics.getNullsFraction(), new Object[0])).isTrue();
        return this;
    }

    public SymbolStatsAssertion lowValue(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getLowValue(), expected, "lowValue mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion lowValueUnknown() {
        return this.lowValue(Double.NEGATIVE_INFINITY);
    }

    public SymbolStatsAssertion highValue(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getHighValue(), expected, "highValue mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion highValueUnknown() {
        return this.highValue(Double.POSITIVE_INFINITY);
    }

    public void empty() {
        this.emptyRange().distinctValuesCount(0.0).nullsFraction(1.0);
    }

    public SymbolStatsAssertion emptyRange() {
        ((AbstractBooleanAssert)Assertions.assertThat((Double.isNaN(this.statistics.getLowValue()) && Double.isNaN(this.statistics.getHighValue()) ? 1 : 0) != 0).describedAs("expected empty range (NaN, NaN) but got (" + this.statistics.getLowValue() + ", " + this.statistics.getHighValue() + ") instead", new Object[0])).isTrue();
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.statistics.getDistinctValuesCount()).describedAs("expected no distinctValuesCount", new Object[0])).isEqualTo(0.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.statistics.getAverageRowSize()).describedAs("expected 0 average row size", new Object[0])).isEqualTo(0.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.statistics.getNullsFraction()).describedAs("expected all nulls", new Object[0])).isEqualTo(1.0);
        return this;
    }

    public SymbolStatsAssertion unknownRange() {
        return this.lowValueUnknown().highValueUnknown();
    }

    public SymbolStatsAssertion distinctValuesCount(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getDistinctValuesCount(), expected, "distinctValuesCount mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion distinctValuesCountUnknown() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Double.isNaN(this.statistics.getDistinctValuesCount())).describedAs("expected unknown distinctValuesCount but got " + this.statistics.getDistinctValuesCount(), new Object[0])).isTrue();
        return this;
    }

    public SymbolStatsAssertion averageRowSize(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getAverageRowSize(), expected, "average row size mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion dataSizeUnknown() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Double.isNaN(this.statistics.getAverageRowSize())).describedAs("expected unknown dataSize but got " + this.statistics.getAverageRowSize(), new Object[0])).isTrue();
        return this;
    }

    public SymbolStatsAssertion isEqualTo(SymbolStatsEstimate expected) {
        return this.nullsFraction(expected.getNullsFraction()).lowValue(expected.getLowValue()).highValue(expected.getHighValue()).distinctValuesCount(expected.getDistinctValuesCount()).averageRowSize(expected.getAverageRowSize());
    }
}

