/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.secrets.SecretsResolver;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.PrepareTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.QueryUtil;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.Statement;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPrepareTask {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testPrepare() {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")));
        String sqlString = "PREPARE my_query FROM SELECT * FROM foo";
        Map<String, String> statements = this.executePrepare("my_query", (Statement)query, sqlString, SessionTestUtils.TEST_SESSION);
        Assertions.assertThat(statements).isEqualTo((Object)ImmutableMap.of((Object)"my_query", (Object)"SELECT *\nFROM\n  foo\n"));
    }

    @Test
    public void testPrepareNameExists() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT bar, baz from foo").build();
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")));
        String sqlString = "PREPARE my_query FROM SELECT * FROM foo";
        Map<String, String> statements = this.executePrepare("my_query", (Statement)query, sqlString, session);
        Assertions.assertThat(statements).isEqualTo((Object)ImmutableMap.of((Object)"my_query", (Object)"SELECT *\nFROM\n  foo\n"));
    }

    @Test
    public void testPrepareInvalidStatement() {
        Execute statement = new Execute(new NodeLocation(1, 1), QueryUtil.identifier((String)"foo"), Collections.emptyList());
        String sqlString = "PREPARE my_query FROM EXECUTE foo";
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.lambda$testPrepareInvalidStatement$0((Statement)statement, sqlString)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("Invalid statement type for prepared statement: EXECUTE");
    }

    private Map<String, String> executePrepare(String statementName, Statement statement, String sqlString, Session session) {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControl = new AccessControlManager(NodeVersion.UNKNOWN, transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), new SecretsResolver((Map)ImmutableMap.of()), "default");
        accessControl.setSystemAccessControls(List.of(AllowAllSystemAccessControl.INSTANCE));
        QueryStateMachine stateMachine = QueryStateMachine.begin(Optional.empty(), (String)sqlString, Optional.empty(), (Session)TestingSession.testSession((Session)session), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
        Prepare prepare = new Prepare(QueryUtil.identifier((String)statementName), statement);
        new PrepareTask(new SqlParser()).execute(prepare, stateMachine, Collections.emptyList(), WarningCollector.NOOP);
        return stateMachine.getAddedPreparedStatements();
    }

    private /* synthetic */ void lambda$testPrepareInvalidStatement$0(Statement statement, String sqlString) throws Throwable {
        this.executePrepare("my_query", statement, sqlString, SessionTestUtils.TEST_SESSION);
    }
}

