/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.timesharing;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.trino.execution.SplitRunner;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.executor.TaskHandle;
import io.trino.execution.executor.timesharing.MultilevelSplitQueue;
import io.trino.execution.executor.timesharing.TimeSharingTaskExecutor;
import io.trino.execution.executor.timesharing.TimeSharingTaskHandle;
import io.trino.spi.QueryId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestTimeSharingTaskExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=100)
    public void testTasksComplete() throws Exception {
        TestingTicker ticker = new TestingTicker();
        Duration splitProcessingDurationThreshold = new Duration(10.0, TimeUnit.MINUTES);
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(4, 8, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        try {
            ticker.increment(20L, TimeUnit.MILLISECONDS);
            TaskId taskId = new TaskId(new StageId("test", 0), 0, 0);
            TimeSharingTaskHandle taskHandle = taskExecutor.addTask(taskId, () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty());
            Phaser beginPhase = new Phaser();
            beginPhase.register();
            Phaser verificationComplete = new Phaser();
            verificationComplete.register();
            TestingJob driver1 = new TestingJob(ticker, new Phaser(), beginPhase, verificationComplete, 10, 0);
            ListenableFuture future1 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits((TaskHandle)taskHandle, true, (List)ImmutableList.of((Object)driver1)));
            TestingJob driver2 = new TestingJob(ticker, new Phaser(), beginPhase, verificationComplete, 10, 0);
            ListenableFuture future2 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits((TaskHandle)taskHandle, true, (List)ImmutableList.of((Object)driver2)));
            Assertions.assertThat((int)driver1.getCompletedPhases()).isEqualTo(0);
            Assertions.assertThat((int)driver2.getCompletedPhases()).isEqualTo(0);
            beginPhase.arriveAndAwaitAdvance();
            Assertions.assertThat((int)driver1.getCompletedPhases()).isEqualTo(0);
            Assertions.assertThat((int)driver2.getCompletedPhases()).isEqualTo(0);
            ticker.increment(60L, TimeUnit.SECONDS);
            Assertions.assertThat((Collection)taskExecutor.getStuckSplitTaskIds(splitProcessingDurationThreshold, runningSplitInfo -> true)).isEmpty();
            Assertions.assertThat((long)taskExecutor.getRunAwaySplitCount()).isEqualTo(0L);
            ticker.increment(600L, TimeUnit.SECONDS);
            Assertions.assertThat((long)taskExecutor.getRunAwaySplitCount()).isEqualTo(2L);
            Assertions.assertThat((Collection)taskExecutor.getStuckSplitTaskIds(splitProcessingDurationThreshold, runningSplitInfo -> true)).isEqualTo((Object)ImmutableSet.of((Object)taskId));
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            Assertions.assertThat((int)driver1.getCompletedPhases()).isEqualTo(1);
            Assertions.assertThat((int)driver2.getCompletedPhases()).isEqualTo(1);
            verificationComplete.arriveAndAwaitAdvance();
            TestingJob driver3 = new TestingJob(ticker, new Phaser(), beginPhase, verificationComplete, 10, 0);
            ListenableFuture future3 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits((TaskHandle)taskHandle, false, (List)ImmutableList.of((Object)driver3)));
            beginPhase.arriveAndAwaitAdvance();
            Assertions.assertThat((int)driver1.getCompletedPhases()).isEqualTo(2);
            Assertions.assertThat((int)driver2.getCompletedPhases()).isEqualTo(2);
            Assertions.assertThat((int)driver3.getCompletedPhases()).isEqualTo(0);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            for (int i = 0; i < 7; ++i) {
                verificationComplete.arriveAndAwaitAdvance();
                beginPhase.arriveAndAwaitAdvance();
                Assertions.assertThat((int)beginPhase.getPhase()).isEqualTo(verificationComplete.getPhase() + 1);
            }
            Assertions.assertThat((int)driver1.getCompletedPhases()).isEqualTo(10);
            Assertions.assertThat((int)driver2.getCompletedPhases()).isEqualTo(10);
            Assertions.assertThat((int)driver3.getCompletedPhases()).isEqualTo(8);
            future1.get(1L, TimeUnit.SECONDS);
            future2.get(1L, TimeUnit.SECONDS);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            Assertions.assertThat((int)driver1.getCompletedPhases()).isEqualTo(10);
            Assertions.assertThat((int)driver2.getCompletedPhases()).isEqualTo(10);
            Assertions.assertThat((int)driver3.getCompletedPhases()).isEqualTo(10);
            future3.get(1L, TimeUnit.SECONDS);
            verificationComplete.arriveAndAwaitAdvance();
            Assertions.assertThat((int)driver1.getFirstPhase()).isEqualTo(0);
            Assertions.assertThat((int)driver2.getFirstPhase()).isEqualTo(0);
            Assertions.assertThat((int)driver3.getFirstPhase()).isEqualTo(2);
            Assertions.assertThat((int)driver1.getLastPhase()).isEqualTo(10);
            Assertions.assertThat((int)driver2.getLastPhase()).isEqualTo(10);
            Assertions.assertThat((int)driver3.getLastPhase()).isEqualTo(12);
            ticker.increment(610L, TimeUnit.SECONDS);
            Assertions.assertThat((Collection)taskExecutor.getStuckSplitTaskIds(splitProcessingDurationThreshold, runningSplitInfo -> true)).isEmpty();
            Assertions.assertThat((long)taskExecutor.getRunAwaySplitCount()).isEqualTo(0L);
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=100)
    public void testQuantaFairness() {
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(1, 2, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        try {
            ticker.increment(20L, TimeUnit.MILLISECONDS);
            TaskHandle shortQuantaTaskHandle = taskExecutor.addTask(new TaskId(new StageId("short_quanta", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty());
            TaskHandle longQuantaTaskHandle = taskExecutor.addTask(new TaskId(new StageId("long_quanta", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty());
            Phaser endQuantaPhaser = new Phaser();
            TestingJob shortQuantaDriver = new TestingJob(ticker, new Phaser(), new Phaser(), endQuantaPhaser, 10, 10);
            TestingJob longQuantaDriver = new TestingJob(ticker, new Phaser(), new Phaser(), endQuantaPhaser, 10, 20);
            taskExecutor.enqueueSplits(shortQuantaTaskHandle, true, (List)ImmutableList.of((Object)shortQuantaDriver));
            taskExecutor.enqueueSplits(longQuantaTaskHandle, true, (List)ImmutableList.of((Object)longQuantaDriver));
            for (int i = 0; i < 11; ++i) {
                endQuantaPhaser.arriveAndAwaitAdvance();
            }
            Assertions.assertThat((shortQuantaDriver.getCompletedPhases() >= 7 && shortQuantaDriver.getCompletedPhases() <= 8 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((longQuantaDriver.getCompletedPhases() >= 3 && longQuantaDriver.getCompletedPhases() <= 4 ? 1 : 0) != 0).isTrue();
            endQuantaPhaser.arriveAndDeregister();
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=100)
    public void testLevelMovement() {
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(2, 2, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        try {
            ticker.increment(20L, TimeUnit.MILLISECONDS);
            TimeSharingTaskHandle testTaskHandle = taskExecutor.addTask(new TaskId(new StageId("test", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty());
            Phaser globalPhaser = new Phaser();
            globalPhaser.bulkRegister(3);
            int quantaTimeMills = 500;
            int phasesPerSecond = 1000 / quantaTimeMills;
            int totalPhases = MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1] * phasesPerSecond;
            TestingJob driver1 = new TestingJob(ticker, globalPhaser, new Phaser(), new Phaser(), totalPhases, quantaTimeMills);
            TestingJob driver2 = new TestingJob(ticker, globalPhaser, new Phaser(), new Phaser(), totalPhases, quantaTimeMills);
            taskExecutor.enqueueSplits((TaskHandle)testTaskHandle, true, (List)ImmutableList.of((Object)driver1, (Object)driver2));
            int completedPhases = 0;
            for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
                while (completedPhases / phasesPerSecond < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1]) {
                    globalPhaser.arriveAndAwaitAdvance();
                    ++completedPhases;
                }
                Assertions.assertThat((int)testTaskHandle.getPriority().getLevel()).isEqualTo(i + 1);
            }
            globalPhaser.arriveAndDeregister();
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=100)
    public void testLevelMultipliers() throws Exception {
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(6, 3, 3, 4, new MultilevelSplitQueue(2.0), (Ticker)ticker);
        taskExecutor.start();
        try {
            ticker.increment(20L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
                TaskHandle[] taskHandles = new TaskHandle[]{taskExecutor.addTask(new TaskId(new StageId("test1", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty()), taskExecutor.addTask(new TaskId(new StageId("test2", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty()), taskExecutor.addTask(new TaskId(new StageId("test3", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty())};
                TestingJob task0Job = new TestingJob(ticker, new Phaser(), new Phaser(), new Phaser(), 1, MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] * 1000);
                taskExecutor.enqueueSplits(taskHandles[0], true, (List)ImmutableList.of((Object)task0Job));
                TestingJob task1Job = new TestingJob(ticker, new Phaser(), new Phaser(), new Phaser(), 1, MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i] * 1000);
                taskExecutor.enqueueSplits(taskHandles[1], true, (List)ImmutableList.of((Object)task1Job));
                TestingJob task2Job = new TestingJob(ticker, new Phaser(), new Phaser(), new Phaser(), 1, MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i] * 1000);
                taskExecutor.enqueueSplits(taskHandles[2], true, (List)ImmutableList.of((Object)task2Job));
                task0Job.getCompletedFuture().get();
                task1Job.getCompletedFuture().get();
                task2Job.getCompletedFuture().get();
                Phaser globalPhaser = new Phaser(7);
                int phasesForNextLevel = MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] - MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i];
                TestingJob[] drivers = new TestingJob[6];
                for (int j = 0; j < 6; ++j) {
                    drivers[j] = new TestingJob(ticker, globalPhaser, new Phaser(), new Phaser(), phasesForNextLevel, 1000);
                }
                taskExecutor.enqueueSplits(taskHandles[0], true, (List)ImmutableList.of((Object)drivers[0], (Object)drivers[1]));
                taskExecutor.enqueueSplits(taskHandles[1], true, (List)ImmutableList.of((Object)drivers[2], (Object)drivers[3]));
                taskExecutor.enqueueSplits(taskHandles[2], true, (List)ImmutableList.of((Object)drivers[4], (Object)drivers[5]));
                int lowerLevelStart = drivers[2].getCompletedPhases() + drivers[3].getCompletedPhases() + drivers[4].getCompletedPhases() + drivers[5].getCompletedPhases();
                int higherLevelStart = drivers[0].getCompletedPhases() + drivers[1].getCompletedPhases();
                while (Arrays.stream(drivers).noneMatch(TestingJob::isFinished)) {
                    globalPhaser.arriveAndAwaitAdvance();
                    int lowerLevelEnd = drivers[2].getCompletedPhases() + drivers[3].getCompletedPhases() + drivers[4].getCompletedPhases() + drivers[5].getCompletedPhases();
                    int lowerLevelTime = lowerLevelEnd - lowerLevelStart;
                    int higherLevelEnd = drivers[0].getCompletedPhases() + drivers[1].getCompletedPhases();
                    int higherLevelTime = higherLevelEnd - higherLevelStart;
                    if (higherLevelTime <= 20) continue;
                    io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(lowerLevelTime), (Comparable)Integer.valueOf(higherLevelTime * 2 - 10));
                    io.airlift.testing.Assertions.assertLessThan((Comparable)Integer.valueOf(higherLevelTime), (Comparable)Integer.valueOf(lowerLevelTime * 2 + 10));
                }
                globalPhaser.arriveAndDeregister();
                taskExecutor.removeTask(taskHandles[0]);
                taskExecutor.removeTask(taskHandles[1]);
                taskExecutor.removeTask(taskHandles[2]);
            }
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskHandle() {
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(4, 8, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        try {
            TaskId taskId = new TaskId(new StageId("test", 0), 0, 0);
            TimeSharingTaskHandle taskHandle = taskExecutor.addTask(taskId, () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty());
            Phaser beginPhase = new Phaser();
            beginPhase.register();
            Phaser verificationComplete = new Phaser();
            verificationComplete.register();
            TestingJob driver1 = new TestingJob(ticker, new Phaser(), beginPhase, verificationComplete, 10, 0);
            TestingJob driver2 = new TestingJob(ticker, new Phaser(), beginPhase, verificationComplete, 10, 0);
            taskExecutor.enqueueSplits((TaskHandle)taskHandle, true, (List)ImmutableList.of((Object)driver1));
            Assertions.assertThat((int)taskHandle.getRunningLeafSplits()).isEqualTo(0);
            taskExecutor.enqueueSplits((TaskHandle)taskHandle, false, (List)ImmutableList.of((Object)driver2));
            Assertions.assertThat((int)taskHandle.getRunningLeafSplits()).isEqualTo(1);
            beginPhase.arriveAndDeregister();
            verificationComplete.arriveAndDeregister();
        }
        finally {
            taskExecutor.stop();
        }
    }

    @Test
    public void testLevelContributionCap() {
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TimeSharingTaskHandle handle0 = new TimeSharingTaskHandle(new TaskId(new StageId("test0", 0), 0, 0), splitQueue, () -> 1.0, 1, new Duration(1.0, TimeUnit.SECONDS), OptionalInt.empty());
        TimeSharingTaskHandle handle1 = new TimeSharingTaskHandle(new TaskId(new StageId("test1", 0), 0, 0), splitQueue, () -> 1.0, 1, new Duration(1.0, TimeUnit.SECONDS), OptionalInt.empty());
        for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
            long levelAdvanceTime = TimeUnit.SECONDS.toNanos(MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] - MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i]);
            handle0.addScheduledNanos(levelAdvanceTime);
            Assertions.assertThat((int)handle0.getPriority().getLevel()).isEqualTo(i + 1);
            handle1.addScheduledNanos(levelAdvanceTime);
            Assertions.assertThat((int)handle1.getPriority().getLevel()).isEqualTo(i + 1);
            Assertions.assertThat((long)splitQueue.getLevelScheduledTime(i)).isEqualTo(2L * Math.min(levelAdvanceTime, MultilevelSplitQueue.LEVEL_CONTRIBUTION_CAP));
            Assertions.assertThat((long)splitQueue.getLevelScheduledTime(i + 1)).isEqualTo(0L);
        }
    }

    @Test
    public void testUpdateLevelWithCap() {
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TimeSharingTaskHandle handle0 = new TimeSharingTaskHandle(new TaskId(new StageId("test0", 0), 0, 0), splitQueue, () -> 1.0, 1, new Duration(1.0, TimeUnit.SECONDS), OptionalInt.empty());
        long quantaNanos = TimeUnit.MINUTES.toNanos(10L);
        handle0.addScheduledNanos(quantaNanos);
        long cappedNanos = Math.min(quantaNanos, MultilevelSplitQueue.LEVEL_CONTRIBUTION_CAP);
        for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
            long thisLevelTime = Math.min(TimeUnit.SECONDS.toNanos(MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] - MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i]), cappedNanos);
            Assertions.assertThat((long)splitQueue.getLevelScheduledTime(i)).isEqualTo(thisLevelTime);
            cappedNanos -= thisLevelTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testMinMaxDriversPerTask() {
        int maxDriversPerTask = 2;
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(4, 16, 1, maxDriversPerTask, splitQueue, (Ticker)ticker);
        taskExecutor.start();
        try {
            int batch;
            TimeSharingTaskHandle testTaskHandle = taskExecutor.addTask(new TaskId(new StageId("test", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty());
            int batchCount = 4;
            TestingJob[] splits = new TestingJob[8];
            Phaser[] phasers = new Phaser[batchCount];
            for (batch = 0; batch < batchCount; ++batch) {
                phasers[batch] = new Phaser();
                phasers[batch].register();
                TestingJob split1 = new TestingJob(ticker, new Phaser(), new Phaser(), phasers[batch], 1, 0);
                TestingJob split2 = new TestingJob(ticker, new Phaser(), new Phaser(), phasers[batch], 1, 0);
                splits[2 * batch] = split1;
                splits[2 * batch + 1] = split2;
                taskExecutor.enqueueSplits((TaskHandle)testTaskHandle, false, (List)ImmutableList.of((Object)split1, (Object)split2));
            }
            for (batch = 0; batch < batchCount; ++batch) {
                TestTimeSharingTaskExecutor.waitUntilSplitsStart((List<TestingJob>)ImmutableList.of((Object)splits[2 * batch], (Object)splits[2 * batch + 1]));
                this.assertSplitStates(2 * batch + 1, splits);
                phasers[batch].arriveAndDeregister();
            }
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testUserSpecifiedMaxDriversPerTask() {
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(4, 16, 2, 4, splitQueue, (Ticker)ticker);
        taskExecutor.start();
        try {
            int batch;
            TimeSharingTaskHandle testTaskHandle = taskExecutor.addTask(new TaskId(new StageId("test", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.of(1));
            int batchCount = 4;
            TestingJob[] splits = new TestingJob[4];
            Phaser[] phasers = new Phaser[batchCount];
            for (batch = 0; batch < batchCount; ++batch) {
                TestingJob split;
                phasers[batch] = new Phaser();
                phasers[batch].register();
                splits[batch] = split = new TestingJob(ticker, new Phaser(), new Phaser(), phasers[batch], 1, 0);
                taskExecutor.enqueueSplits((TaskHandle)testTaskHandle, false, (List)ImmutableList.of((Object)split));
            }
            for (batch = 0; batch < batchCount; ++batch) {
                TestTimeSharingTaskExecutor.waitUntilSplitsStart((List<TestingJob>)ImmutableList.of((Object)splits[batch]));
                this.assertSplitStates(batch, splits);
                phasers[batch].arriveAndDeregister();
            }
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinDriversPerTaskWhenTargetConcurrencyIncreases() {
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(4, 1, 2, 2, splitQueue, (Ticker)ticker);
        taskExecutor.start();
        try {
            TimeSharingTaskHandle testTaskHandle = taskExecutor.addTask(new TaskId(new StageId(new QueryId("test"), 0), 0, 0), () -> 0.0, 1, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.of(2));
            int batchCount = 3;
            Object[] splits = new TestingJob[3];
            Phaser[] phasers = new Phaser[batchCount];
            for (int batch = 0; batch < batchCount; ++batch) {
                phasers[batch] = new Phaser();
                phasers[batch].register();
                TestingJob split = new TestingJob(ticker, new Phaser(), new Phaser(), phasers[batch], 1, 0);
                splits[batch] = split;
            }
            taskExecutor.enqueueSplits((TaskHandle)testTaskHandle, false, (List)ImmutableList.copyOf((Object[])splits));
            TestTimeSharingTaskExecutor.waitUntilSplitsStart((List<TestingJob>)ImmutableList.of((Object)splits[0]));
            this.assertSplitStates(0, (TestingJob[])splits);
            phasers[0].arriveAndDeregister();
            TestTimeSharingTaskExecutor.waitUntilSplitsStart((List<TestingJob>)ImmutableList.of((Object)splits[1], (Object)splits[2]));
        }
        finally {
            taskExecutor.stop();
        }
    }

    @Test
    public void testLeafSplitsSize() {
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TestingTicker ticker = new TestingTicker();
        TimeSharingTaskExecutor taskExecutor = new TimeSharingTaskExecutor(4, 1, 2, 2, splitQueue, (Ticker)ticker);
        TimeSharingTaskHandle testTaskHandle = taskExecutor.addTask(new TaskId(new StageId("test", 0), 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS), OptionalInt.empty());
        TestingJob driver1 = new TestingJob(ticker, new Phaser(), new Phaser(), new Phaser(), 1, 500);
        TestingJob driver2 = new TestingJob(ticker, new Phaser(), new Phaser(), new Phaser(), 1, 2);
        ticker.increment(0L, TimeUnit.SECONDS);
        taskExecutor.enqueueSplits((TaskHandle)testTaskHandle, false, (List)ImmutableList.of((Object)driver1, (Object)driver2));
        Assertions.assertThat((boolean)Double.isNaN(taskExecutor.getLeafSplitsSize().getAllTime().getMax())).isTrue();
        ticker.increment(1L, TimeUnit.SECONDS);
        taskExecutor.enqueueSplits((TaskHandle)testTaskHandle, false, (List)ImmutableList.of((Object)driver1));
        Assertions.assertThat((double)taskExecutor.getLeafSplitsSize().getAllTime().getMax()).isEqualTo(2.0);
        ticker.increment(1L, TimeUnit.SECONDS);
        taskExecutor.enqueueSplits((TaskHandle)testTaskHandle, true, (List)ImmutableList.of((Object)driver1));
        Assertions.assertThat((double)taskExecutor.getLeafSplitsSize().getAllTime().getMax()).isEqualTo(2.0);
    }

    private void assertSplitStates(int endIndex, TestingJob[] splits) {
        int i;
        for (i = 0; i <= endIndex; ++i) {
            Assertions.assertThat((boolean)splits[i].isStarted()).isTrue();
        }
        for (i = endIndex + 1; i < splits.length; ++i) {
            Assertions.assertThat((boolean)splits[i].isStarted()).isFalse();
        }
    }

    private static void waitUntilSplitsStart(List<TestingJob> splits) {
        while (splits.stream().anyMatch(split -> !split.isStarted())) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private static class TestingJob
    implements SplitRunner {
        private final TestingTicker ticker;
        private final Phaser globalPhaser;
        private final Phaser beginQuantaPhaser;
        private final Phaser endQuantaPhaser;
        private final int requiredPhases;
        private final int quantaTimeMillis;
        private final AtomicInteger completedPhases = new AtomicInteger();
        private final AtomicInteger firstPhase = new AtomicInteger(-1);
        private final AtomicInteger lastPhase = new AtomicInteger(-1);
        private final AtomicBoolean started = new AtomicBoolean();
        private final SettableFuture<Void> completed = SettableFuture.create();

        public TestingJob(TestingTicker ticker, Phaser globalPhaser, Phaser beginQuantaPhaser, Phaser endQuantaPhaser, int requiredPhases, int quantaTimeMillis) {
            this.ticker = ticker;
            this.globalPhaser = globalPhaser;
            this.beginQuantaPhaser = beginQuantaPhaser;
            this.endQuantaPhaser = endQuantaPhaser;
            this.requiredPhases = requiredPhases;
            this.quantaTimeMillis = quantaTimeMillis;
            beginQuantaPhaser.register();
            endQuantaPhaser.register();
            if (globalPhaser.getRegisteredParties() == 0) {
                globalPhaser.register();
            }
        }

        private int getFirstPhase() {
            return this.firstPhase.get();
        }

        private int getLastPhase() {
            return this.lastPhase.get();
        }

        private int getCompletedPhases() {
            return this.completedPhases.get();
        }

        public ListenableFuture<Void> processFor(Duration duration) {
            this.started.set(true);
            this.ticker.increment((long)this.quantaTimeMillis, TimeUnit.MILLISECONDS);
            this.globalPhaser.arriveAndAwaitAdvance();
            int phase = this.beginQuantaPhaser.arriveAndAwaitAdvance();
            this.firstPhase.compareAndSet(-1, phase - 1);
            this.lastPhase.set(phase);
            this.endQuantaPhaser.arriveAndAwaitAdvance();
            if (this.completedPhases.incrementAndGet() >= this.requiredPhases) {
                this.endQuantaPhaser.arriveAndDeregister();
                this.beginQuantaPhaser.arriveAndDeregister();
                this.globalPhaser.arriveAndDeregister();
                this.completed.set(null);
            }
            return Futures.immediateVoidFuture();
        }

        public String getInfo() {
            return "testing-split";
        }

        public int getPipelineId() {
            return 0;
        }

        public Span getPipelineSpan() {
            return Span.getInvalid();
        }

        public boolean isFinished() {
            return this.completed.isDone();
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public void close() {
        }

        public Future<Void> getCompletedFuture() {
            return this.completed;
        }
    }
}

