/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import io.trino.execution.resourcegroups.WeightedFairQueue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWeightedFairQueue {
    @Test
    public void testBasic() {
        WeightedFairQueue queue = new WeightedFairQueue();
        String item1 = "1";
        String item2 = "2";
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(1, 1));
        queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(2, 1));
        Assertions.assertThat((int)queue.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo(item2);
        Assertions.assertThat((boolean)queue.contains((Object)item1)).isTrue();
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo(item1);
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo(null);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo(null);
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
    }

    @Test
    public void testUpdate() {
        WeightedFairQueue queue = new WeightedFairQueue();
        String item1 = "1";
        String item2 = "2";
        String item3 = "3";
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(1, 1));
        queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(2, 1));
        queue.addOrUpdate((Object)item3, new WeightedFairQueue.Usage(3, 1));
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo(item3);
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(4, 1));
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo(item1);
        Assertions.assertThat((String)((String)queue.poll())).isEqualTo(item2);
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
    }

    @Test
    public void testMultipleWinners() {
        WeightedFairQueue queue = new WeightedFairQueue();
        String item1 = "1";
        String item2 = "2";
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(2, 0));
        queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(1, 0));
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < 1000; ++i) {
            if (((String)queue.poll()).equals(item1)) {
                queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(2, 0));
                ++count1;
                continue;
            }
            queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(1, 0));
            ++count2;
        }
        Assertions.assertThat((int)count1).isEqualTo(500);
        Assertions.assertThat((int)count2).isEqualTo(500);
    }
}

