/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Ticker;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import io.airlift.testing.TempFile;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.trino.execution.scheduler.FileBasedNetworkTopology;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.spi.HostAddress;
import java.io.File;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileBasedNetworkTopology {
    private final File topologyFile = new File(Resources.getResource(this.getClass(), (String)"topology.txt").toURI());
    private final File topologyNewFile = new File(Resources.getResource(this.getClass(), (String)"topology-new.txt").toURI());

    @Test
    public void testLocate() {
        FileBasedNetworkTopology topology = new FileBasedNetworkTopology(this.topologyFile, new Duration(1.0, TimeUnit.DAYS), (Ticker)new TestingTicker());
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"0.0.0.0"))).isEqualTo((Object)new NetworkLocation(new String[0]));
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"not-exist.example.com"))).isEqualTo((Object)new NetworkLocation(new String[0]));
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1"))).isEqualTo((Object)new NetworkLocation(new String[]{"region1", "rack1", "machine1"}));
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.2"))).isEqualTo((Object)new NetworkLocation(new String[]{"region1", "rack1", "machine2"}));
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"hdfs01.example.com"))).isEqualTo((Object)new NetworkLocation(new String[]{"region2", "rack2", "machine3"}));
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1:8080"))).isEqualTo((Object)new NetworkLocation(new String[]{"region1", "rack1", "machine1"}));
    }

    @Test
    public void testRefresh() throws Exception {
        try (TempFile tempFile = new TempFile();){
            Files.copy((File)this.topologyFile, (File)tempFile.file());
            TestingTicker ticker = new TestingTicker();
            FileBasedNetworkTopology topology = new FileBasedNetworkTopology(tempFile.file(), new Duration(1.0, TimeUnit.DAYS), (Ticker)ticker);
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"not-exist.example.com"))).isEqualTo((Object)new NetworkLocation(new String[0]));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1"))).isEqualTo((Object)new NetworkLocation(new String[]{"region1", "rack1", "machine1"}));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.2"))).isEqualTo((Object)new NetworkLocation(new String[]{"region1", "rack1", "machine2"}));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.3"))).isEqualTo((Object)new NetworkLocation(new String[0]));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"new"))).isEqualTo((Object)new NetworkLocation(new String[0]));
            Files.copy((File)this.topologyNewFile, (File)tempFile.file());
            ticker.increment(1L, TimeUnit.DAYS);
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"new"))).isEqualTo((Object)new NetworkLocation(new String[]{"new", "rack", "machine"}));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"not-exist.example.com"))).isEqualTo((Object)new NetworkLocation(new String[0]));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1"))).isEqualTo((Object)new NetworkLocation(new String[]{"region1", "rack1", "machine5"}));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.2"))).isEqualTo((Object)new NetworkLocation(new String[0]));
            Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.3"))).isEqualTo((Object)new NetworkLocation(new String[]{"region1", "rack1", "machine6"}));
        }
    }
}

