/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.execution.scheduler.SubnetBasedTopology;
import io.trino.spi.HostAddress;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSubnetTopology {
    @Test
    public void testSubnetTopologyIpv4() {
        SubnetBasedTopology topology = new SubnetBasedTopology((List)ImmutableList.of((Object)24, (Object)25, (Object)27), SubnetBasedTopology.AddressProtocol.IPv4);
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.172"))).isEqualTo((Object)new NetworkLocation(new String[]{"192.168.0.0", "192.168.0.128", "192.168.0.160", "192.168.0.172"}));
        SubnetBasedTopology noTopology = new SubnetBasedTopology((List)ImmutableList.of(), SubnetBasedTopology.AddressProtocol.IPv4);
        Assertions.assertThat((Object)noTopology.locate(HostAddress.fromString((String)"192.168.0.172"))).isEqualTo((Object)new NetworkLocation(new String[]{"192.168.0.172"}));
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"2001:db8:0:0:1:0:0:1"))).isEqualTo((Object)NetworkLocation.ROOT_LOCATION);
        Assertions.assertThat((Object)noTopology.locate(HostAddress.fromString((String)"2001:db8:0:0:1:0:0:1"))).isEqualTo((Object)NetworkLocation.ROOT_LOCATION);
    }

    @Test
    public void testSubnetTopologyIpv6() {
        SubnetBasedTopology topology = new SubnetBasedTopology((List)ImmutableList.of((Object)96, (Object)110, (Object)112, (Object)120), SubnetBasedTopology.AddressProtocol.IPv6);
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"2001:db8::ff00:42:8329"))).isEqualTo((Object)new NetworkLocation(new String[]{"2001:db8::ff00:0:0", "2001:db8::ff00:40:0", "2001:db8::ff00:42:0", "2001:db8::ff00:42:8300", "2001:db8::ff00:42:8329"}));
        SubnetBasedTopology noTopology = new SubnetBasedTopology((List)ImmutableList.of(), SubnetBasedTopology.AddressProtocol.IPv6);
        Assertions.assertThat((Object)noTopology.locate(HostAddress.fromString((String)"2001:db8::ff00:42:8329"))).isEqualTo((Object)new NetworkLocation(new String[]{"2001:db8::ff00:42:8329"}));
        Assertions.assertThat((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1"))).isEqualTo((Object)NetworkLocation.ROOT_LOCATION);
        Assertions.assertThat((Object)noTopology.locate(HostAddress.fromString((String)"192.168.0.1"))).isEqualTo((Object)NetworkLocation.ROOT_LOCATION);
    }

    @Test
    public void testBadInitialization() {
        Assertions.assertThatThrownBy(() -> new SubnetBasedTopology((List)ImmutableList.of((Object)25, (Object)34), SubnetBasedTopology.AddressProtocol.IPv4)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new SubnetBasedTopology((List)ImmutableList.of((Object)-3, (Object)5), SubnetBasedTopology.AddressProtocol.IPv4)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new SubnetBasedTopology((List)ImmutableList.of((Object)25, (Object)22), SubnetBasedTopology.AddressProtocol.IPv4)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new SubnetBasedTopology((List)ImmutableList.of((Object)95, (Object)130), SubnetBasedTopology.AddressProtocol.IPv6)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new SubnetBasedTopology((List)ImmutableList.of((Object)-3, (Object)100), SubnetBasedTopology.AddressProtocol.IPv6)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new SubnetBasedTopology((List)ImmutableList.of((Object)122, (Object)120), SubnetBasedTopology.AddressProtocol.IPv6)).isInstanceOf(IllegalArgumentException.class);
    }
}

