/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SingleDistributionSplitAssigner;
import io.trino.execution.scheduler.faulttolerant.SplitAssignerTester;
import io.trino.execution.scheduler.faulttolerant.TestingConnectorSplit;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSingleDistributionSplitAssigner {
    private static final PlanNodeId PLAN_NODE_1 = new PlanNodeId("plan-node-1");
    private static final PlanNodeId PLAN_NODE_2 = new PlanNodeId("plan-node-2");

    @Test
    public void testNoSources() {
        Optional<HostAddress> hostRequirement = Optional.of(HostAddress.fromParts((String)"localhost", (int)8080));
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner(hostRequirement, (Set)ImmutableSet.of());
        SplitAssignerTester tester = new SplitAssignerTester();
        tester.update(splitAssigner.finish());
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(1);
        Assertions.assertThat((Object)tester.getNodeRequirements(0)).isEqualTo((Object)new NodeRequirements(Optional.empty(), hostRequirement, false));
        Assertions.assertThat((boolean)tester.isSealed(0)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreTaskPartitions()).isTrue();
    }

    @Test
    public void testEmptySource() {
        Optional<HostAddress> hostRequirement = Optional.of(HostAddress.fromParts((String)"localhost", (int)8080));
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner(hostRequirement, (Set)ImmutableSet.of((Object)PLAN_NODE_1));
        SplitAssignerTester tester = new SplitAssignerTester();
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of(), true));
        tester.update(splitAssigner.finish());
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(1);
        Assertions.assertThat((Object)tester.getNodeRequirements(0)).isEqualTo((Object)new NodeRequirements(Optional.empty(), hostRequirement, false));
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).isEmpty();
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1)).isTrue();
        Assertions.assertThat((boolean)tester.isSealed(0)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreTaskPartitions()).isTrue();
    }

    @Test
    public void testSingleSource() {
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner(Optional.empty(), (Set)ImmutableSet.of((Object)PLAN_NODE_1));
        SplitAssignerTester tester = new SplitAssignerTester();
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(0);
        Assertions.assertThat((boolean)tester.isNoMoreTaskPartitions()).isFalse();
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(1)), false));
        tester.update(splitAssigner.finish());
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((boolean)tester.isNoMoreTaskPartitions()).isTrue();
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(2), (Object)1, (Object)this.createSplit(3)), false));
        tester.update(splitAssigner.finish());
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactly((Object[])new Integer[]{1, 2, 3});
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1)).isFalse();
        Assertions.assertThat((boolean)tester.isSealed(0)).isFalse();
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(4)), true));
        tester.update(splitAssigner.finish());
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1)).isTrue();
        Assertions.assertThat((boolean)tester.isSealed(0)).isTrue();
    }

    @Test
    public void testMultipleSources() {
        SingleDistributionSplitAssigner splitAssigner = new SingleDistributionSplitAssigner(Optional.empty(), (Set)ImmutableSet.of((Object)PLAN_NODE_1, (Object)PLAN_NODE_2));
        SplitAssignerTester tester = new SplitAssignerTester();
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(0);
        Assertions.assertThat((boolean)tester.isNoMoreTaskPartitions()).isFalse();
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(1)), false));
        tester.update(splitAssigner.finish());
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactlyInAnyOrder((Object[])new Integer[]{1});
        Assertions.assertThat((boolean)tester.isNoMoreTaskPartitions()).isTrue();
        tester.update(splitAssigner.assign(PLAN_NODE_2, (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)this.createSplit(2), (Object)1, (Object)this.createSplit(3)), false));
        tester.update(splitAssigner.finish());
        Assertions.assertThat((int)tester.getTaskPartitionCount()).isEqualTo(1);
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_2)).containsExactlyInAnyOrder((Object[])new Integer[]{2, 3});
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1)).isFalse();
        tester.update(splitAssigner.assign(PLAN_NODE_1, (ListMultimap)ImmutableListMultimap.of((Object)2, (Object)this.createSplit(4)), true));
        tester.update(splitAssigner.finish());
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_1)).containsExactlyInAnyOrder((Object[])new Integer[]{1, 4});
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PLAN_NODE_1)).isTrue();
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PLAN_NODE_2)).isFalse();
        Assertions.assertThat((boolean)tester.isSealed(0)).isFalse();
        tester.update(splitAssigner.assign(PLAN_NODE_2, (ListMultimap)ImmutableListMultimap.of((Object)3, (Object)this.createSplit(5)), true));
        tester.update(splitAssigner.finish());
        Assertions.assertThat(tester.getSplitIds(0, PLAN_NODE_2)).containsExactlyInAnyOrder((Object[])new Integer[]{2, 3, 5});
        Assertions.assertThat((boolean)tester.isNoMoreSplits(0, PLAN_NODE_2)).isTrue();
        Assertions.assertThat((boolean)tester.isSealed(0)).isTrue();
    }

    private Split createSplit(int id) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.empty(), Optional.empty()));
    }
}

