/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.memory.MemoryManagerConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestMemoryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MemoryManagerConfig)ConfigAssertions.recordDefaults(MemoryManagerConfig.class)).setMaxQueryMemory(DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemory(DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionCoordinatorTaskMemory(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionTaskMemory(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionTaskMemoryGrowthFactor(3.0).setFaultTolerantExecutionTaskMemoryEstimationQuantile(0.9).setFaultTolerantExecutionTaskRuntimeMemoryEstimationOverhead(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled(true).setFaultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit(DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setLowMemoryQueryKillerPolicy(MemoryManagerConfig.LowMemoryQueryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES).setLowMemoryTaskKillerPolicy(MemoryManagerConfig.LowMemoryTaskKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"query.max-memory", (Object)"2GB").put((Object)"query.max-total-memory", (Object)"3GB").put((Object)"fault-tolerant-execution-coordinator-task-memory", (Object)"123GB").put((Object)"fault-tolerant-execution-task-memory", (Object)"2GB").put((Object)"fault-tolerant-execution-task-memory-growth-factor", (Object)"17.3").put((Object)"fault-tolerant-execution-task-memory-estimation-quantile", (Object)"0.7").put((Object)"fault-tolerant-execution-task-runtime-memory-estimation-overhead", (Object)"300MB").put((Object)"fault-tolerant-execution-memory-requirement-increase-on-worker-crash-enabled", (Object)"false").put((Object)"fault-tolerant-execution-eager-speculative-tasks-node_memory-overcommit", (Object)"21GB").put((Object)"query.low-memory-killer.policy", (Object)"none").put((Object)"task.low-memory-killer.policy", (Object)"none").buildOrThrow();
        MemoryManagerConfig expected = new MemoryManagerConfig().setMaxQueryMemory(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemory(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionCoordinatorTaskMemory(DataSize.of((long)123L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionTaskMemory(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionTaskMemoryGrowthFactor(17.3).setFaultTolerantExecutionTaskMemoryEstimationQuantile(0.7).setFaultTolerantExecutionTaskRuntimeMemoryEstimationOverhead(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFaultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled(false).setFaultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit(DataSize.of((long)21L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setLowMemoryQueryKillerPolicy(MemoryManagerConfig.LowMemoryQueryKillerPolicy.NONE).setLowMemoryTaskKillerPolicy(MemoryManagerConfig.LowMemoryTaskKillerPolicy.NONE);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

