/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.aggregation.ParametricAggregationImplementation;
import io.trino.operator.scalar.ParametricScalar;
import org.assertj.core.api.Assertions;

class AnnotationEngineAssertions {
    private AnnotationEngineAssertions() {
    }

    public static void assertImplementationCount(ParametricScalar scalar, int exact, int specialized, int generic) {
        AnnotationEngineAssertions.assertImplementationCount(scalar.getImplementations(), exact, specialized, generic);
    }

    public static void assertImplementationCount(ParametricImplementationsGroup<?> implementations, int exact, int specialized, int generic) {
        Assertions.assertThat((int)implementations.getExactImplementations().size()).isEqualTo(exact);
        Assertions.assertThat((int)implementations.getSpecializedImplementations().size()).isEqualTo(specialized);
        Assertions.assertThat((int)implementations.getGenericImplementations().size()).isEqualTo(generic);
    }

    public static void assertDependencyCount(ParametricAggregationImplementation implementation, int input, int combine, int output) {
        Assertions.assertThat((int)implementation.getInputDependencies().size()).isEqualTo(input);
        Assertions.assertThat((int)implementation.getCombineDependencies().size()).isEqualTo(combine);
        Assertions.assertThat((int)implementation.getOutputDependencies().size()).isEqualTo(output);
    }
}

