/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.memory.MemoryPool;
import io.trino.memory.QueryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.VariableWidthData;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.block.Block;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.SpillSpaceTracker;
import io.trino.testing.TestingTaskContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.assertj.core.api.Assertions;

public final class GroupByHashYieldAssertion {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"GroupByHashYieldAssertion-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"GroupByHashYieldAssertion-scheduledExecutor-%s"));

    private GroupByHashYieldAssertion() {
    }

    public static List<Page> createPagesWithDistinctHashKeys(Type type, int pageCount, int positionCountPerPage) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(true, (List<Integer>)ImmutableList.of((Object)0), type);
        for (int i = 0; i < pageCount; ++i) {
            rowPagesBuilder.addSequencePage(positionCountPerPage, positionCountPerPage * i);
        }
        return rowPagesBuilder.build();
    }

    public static GroupByHashYieldResult finishOperatorWithYieldingGroupByHash(List<Page> input, Type hashKeyType, OperatorFactory operatorFactory, Function<Operator, Integer> getHashCapacity, long additionalMemoryInBytes) {
        io.airlift.testing.Assertions.assertLessThan((Comparable)Long.valueOf(additionalMemoryInBytes), (Comparable)Long.valueOf(0x200000L), (String)"additionalMemoryInBytes should be a relatively small number");
        LinkedList<Page> result = new LinkedList<Page>();
        QueryId queryId = new QueryId("test_query");
        TaskId anotherTaskId = new TaskId(new StageId("another_query", 0), 0, 0);
        MemoryPool memoryPool = new MemoryPool(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        QueryContext queryContext = new QueryContext(queryId, DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)EXECUTOR, SCHEDULED_EXECUTOR, SCHEDULED_EXECUTOR, DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE), new SpillSpaceTracker(DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        DriverContext driverContext = TestingTaskContext.createTaskContext((QueryContext)queryContext, (Executor)EXECUTOR, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = operatorFactory.createOperator(driverContext);
        byte[] pointer = new byte[12];
        VariableWidthData variableWidthData = new VariableWidthData();
        int yieldCount = 0;
        long maxReservedBytes = 0L;
        for (Page page : input) {
            long pageVariableWidthSize = 0L;
            if (hashKeyType == VarcharType.VARCHAR) {
                long oldVariableWidthSize = variableWidthData.getRetainedSizeBytes();
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    Block block = page.getBlock(0);
                    variableWidthData.allocate(pointer, 0, ((VariableWidthBlock)block.getUnderlyingValueBlock()).getSliceLength(block.getUnderlyingValuePosition(position)));
                }
                pageVariableWidthSize = variableWidthData.getRetainedSizeBytes() - oldVariableWidthSize;
            }
            Assertions.assertThat((boolean)operator.needsInput()).isTrue();
            memoryPool.reserve(anotherTaskId, "test", memoryPool.getFreeBytes() - additionalMemoryInBytes - pageVariableWidthSize);
            long oldMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage();
            int oldCapacity = getHashCapacity.apply(operator);
            operator.addInput(page);
            Page output = operator.getOutput();
            if (output != null) {
                result.add(output);
            }
            long newMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage();
            maxReservedBytes = Math.max(maxReservedBytes, newMemoryUsage);
            if (newMemoryUsage < DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()) {
                memoryPool.free(anotherTaskId, "test", ((Long)memoryPool.getTaskMemoryReservations().get(anotherTaskId)).longValue());
                output = operator.getOutput();
                if (output == null) continue;
                result.add(output);
                continue;
            }
            long actualHashIncreased = newMemoryUsage - oldMemoryUsage - pageVariableWidthSize;
            if (operator.needsInput()) {
                Assertions.assertThat((boolean)operator.getOperatorContext().isWaitingForMemory().isDone()).isTrue();
                Assertions.assertThat((int)getHashCapacity.apply(operator)).isEqualTo(oldCapacity);
                io.airlift.testing.Assertions.assertLessThan((Comparable)Long.valueOf(actualHashIncreased), (Comparable)Long.valueOf(additionalMemoryInBytes));
                memoryPool.free(anotherTaskId, "test", ((Long)memoryPool.getTaskMemoryReservations().get(anotherTaskId)).longValue());
                continue;
            }
            ++yieldCount;
            Assertions.assertThat((boolean)operator.getOperatorContext().isWaitingForMemory().isDone()).isFalse();
            Assertions.assertThat((int)oldCapacity).isEqualTo((long)getHashCapacity.apply(operator).intValue());
            long expectedHashBytes = hashKeyType == BigintType.BIGINT ? GroupByHashYieldAssertion.getHashTableSizeInBytes(hashKeyType, oldCapacity * 2) : GroupByHashYieldAssertion.getHashTableSizeInBytes(hashKeyType, oldCapacity) + (long)oldCapacity;
            io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Long.valueOf(actualHashIncreased), (Comparable)Long.valueOf(expectedHashBytes), (Comparable)Long.valueOf(expectedHashBytes + additionalMemoryInBytes));
            Assertions.assertThat((Object)operator.getOutput()).isNull();
            memoryPool.free(anotherTaskId, "test", ((Long)memoryPool.getTaskMemoryReservations().get(anotherTaskId)).longValue());
            output = operator.getOutput();
            if (output != null) {
                result.add(output);
            }
            Assertions.assertThat((boolean)operator.needsInput()).isTrue();
            io.airlift.testing.Assertions.assertGreaterThan((Comparable)getHashCapacity.apply(operator), (Comparable)Integer.valueOf(oldCapacity));
            long rehashedMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage();
            long expectedMemoryUsageAfterRehash = oldMemoryUsage + GroupByHashYieldAssertion.getHashTableSizeInBytes(hashKeyType, oldCapacity);
            double memoryUsageErrorUpperBound = 1.01;
            double memoryUsageError = (double)rehashedMemoryUsage * 1.0 / (double)expectedMemoryUsageAfterRehash;
            if (memoryUsageError > memoryUsageErrorUpperBound) {
                io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Double.valueOf((double)rehashedMemoryUsage * 1.0 / (double)(expectedMemoryUsageAfterRehash + additionalMemoryInBytes)), (Comparable)Double.valueOf(0.97), (Comparable)Double.valueOf(memoryUsageErrorUpperBound), (String)("rehashedMemoryUsage " + rehashedMemoryUsage + ", expectedMemoryUsageAfterRehash: " + expectedMemoryUsageAfterRehash));
            } else {
                io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Double.valueOf(memoryUsageError), (Comparable)Double.valueOf(0.99), (Comparable)Double.valueOf(memoryUsageErrorUpperBound));
            }
            Assertions.assertThat((boolean)operator.needsInput()).isTrue();
            Assertions.assertThat((boolean)operator.getOperatorContext().isWaitingForMemory().isDone()).isTrue();
        }
        result.addAll(OperatorAssertion.finishOperator(operator));
        return new GroupByHashYieldResult(yieldCount, maxReservedBytes, result);
    }

    private static long getHashTableSizeInBytes(Type hashKeyType, int capacity) {
        if (hashKeyType == BigintType.BIGINT) {
            return (long)capacity * 18L;
        }
        int sizePerEntry = 46;
        return (long)capacity * (long)sizePerEntry;
    }

    public static final class GroupByHashYieldResult {
        private final int yieldCount;
        private final long maxReservedBytes;
        private final List<Page> output;

        public GroupByHashYieldResult(int yieldCount, long maxReservedBytes, List<Page> output) {
            this.yieldCount = yieldCount;
            this.maxReservedBytes = maxReservedBytes;
            this.output = Objects.requireNonNull(output, "output is null");
        }

        public int getYieldCount() {
            return this.yieldCount;
        }

        public long getMaxReservedBytes() {
            return this.maxReservedBytes;
        }

        public List<Page> getOutput() {
            return this.output;
        }
    }
}

