/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalFunctionDependencies;
import io.trino.operator.AnnotationEngineAssertions;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.operator.annotations.LiteralImplementationDependency;
import io.trino.operator.annotations.TypeImplementationDependency;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.ParametricScalar;
import io.trino.operator.scalar.annotations.ParametricScalarImplementation;
import io.trino.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.trino.spi.block.Block;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.Description;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.Signature;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAnnotationEngineForScalars {
    private static final FunctionManager FUNCTION_MANAGER = FunctionManager.createTestingFunctionManager();

    @Test
    public void testSingleImplementationScalarParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SingleImplementationScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Simple scalar with single implementation based on class");
        Assertions.assertThat((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(0)).isFalse();
        AnnotationEngineAssertions.assertImplementationCount(scalar, 1, 0, 0);
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"single_implementation_parametric_scalar"), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        ChoicesSpecializedSqlScalarFunction specialized = (ChoicesSpecializedSqlScalarFunction)scalar.specialize(boundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assertions.assertThat((Optional)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specialized.getChoices().get(0)).getInstanceFactory()).isEmpty();
    }

    @Test
    public void testHiddenScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(HiddenScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isTrue();
    }

    @Test
    public void testNonDeterministicScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(NonDeterministicScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isFalse();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
    }

    @Test
    public void testWithNullablePrimitiveArgScalarParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullablePrimitiveArgScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Simple scalar with nullable primitive");
        Assertions.assertThat((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(0)).isFalse();
        Assertions.assertThat((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(1)).isTrue();
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"scalar_with_nullable"), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        ChoicesSpecializedSqlScalarFunction specialized = (ChoicesSpecializedSqlScalarFunction)scalar.specialize(boundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assertions.assertThat((Optional)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specialized.getChoices().get(0)).getInstanceFactory()).isEmpty();
    }

    @Test
    public void testWithNullableComplexArgScalarParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullableComplexArgScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Simple scalar with nullable complex type");
        Assertions.assertThat((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(0)).isFalse();
        Assertions.assertThat((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(1)).isTrue();
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"scalar_with_nullable_complex"), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        ChoicesSpecializedSqlScalarFunction specialized = (ChoicesSpecializedSqlScalarFunction)scalar.specialize(boundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assertions.assertThat((Optional)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)specialized.getChoices().get(0)).getInstanceFactory()).isEmpty();
    }

    @Test
    public void testStaticMethodScalarParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(StaticMethodScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Simple scalar with single implementation based on method");
    }

    @Test
    public void testMultiScalarParse() {
        Signature expectedSignature1 = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        Signature expectedSignature2 = Signature.builder().returnType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(MultiScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(2);
        ParametricScalar scalar1 = (ParametricScalar)((ImmutableList)functions.stream().filter(function -> function.getFunctionMetadata().getSignature().equals((Object)expectedSignature1)).collect(ImmutableList.toImmutableList())).get(0);
        ParametricScalar scalar2 = (ParametricScalar)((ImmutableList)functions.stream().filter(function -> function.getFunctionMetadata().getSignature().equals((Object)expectedSignature2)).collect(ImmutableList.toImmutableList())).get(0);
        AnnotationEngineAssertions.assertImplementationCount(scalar1, 1, 0, 0);
        AnnotationEngineAssertions.assertImplementationCount(scalar2, 1, 0, 0);
        FunctionMetadata functionMetadata1 = scalar1.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata1.getSignature()).isEqualTo((Object)expectedSignature1);
        Assertions.assertThat((boolean)functionMetadata1.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata1.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata1.getDescription()).isEqualTo("Simple scalar with single implementation based on method 1");
        FunctionMetadata functionMetadata2 = scalar2.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata2.getSignature()).isEqualTo((Object)expectedSignature2);
        Assertions.assertThat((boolean)functionMetadata2.isDeterministic()).isFalse();
        Assertions.assertThat((boolean)functionMetadata2.isHidden()).isTrue();
        Assertions.assertThat((String)functionMetadata2.getDescription()).isEqualTo("Simple scalar with single implementation based on method 2");
    }

    @Test
    public void testParametricScalarParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ParametricScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        AnnotationEngineAssertions.assertImplementationCount(scalar, 0, 2, 0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Parametric scalar description");
    }

    @Test
    public void testComplexParametricScalarParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")}))).build();
        Signature exactSignature = Signature.builder().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.arrayType((TypeSignature)VarcharType.createVarcharType((int)17).getTypeSignature())).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ComplexParametricScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        AnnotationEngineAssertions.assertImplementationCount(scalar.getImplementations(), 1, 0, 1);
        Assertions.assertThat((Object)((Signature)Iterables.getOnlyElement(scalar.getImplementations().getExactImplementations().keySet()))).isEqualTo((Object)exactSignature);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Parametric scalar with exact and generic implementations");
    }

    @Test
    public void testSimpleInjectionScalarParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)BigintType.BIGINT).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SimpleInjectionScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        AnnotationEngineAssertions.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assertions.assertThat((int)parametricScalarImplementationChoices.size()).isEqualTo(1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assertions.assertThat((int)dependencies.size()).isEqualTo(1);
        Assertions.assertThat((Object)((ImplementationDependency)dependencies.get(0))).isInstanceOf(LiteralImplementationDependency.class);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Parametric scalar with literal injected");
    }

    @Test
    public void testConstructorInjectionScalarParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T").returnType((Type)BigintType.BIGINT).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ConstructorInjectionScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        AnnotationEngineAssertions.assertImplementationCount(scalar, 2, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assertions.assertThat((int)parametricScalarImplementationChoices.size()).isEqualTo(1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assertions.assertThat((int)dependencies.size()).isEqualTo(0);
        List constructorDependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getConstructorDependencies();
        Assertions.assertThat((int)constructorDependencies.size()).isEqualTo(1);
        Assertions.assertThat((Object)((ImplementationDependency)constructorDependencies.get(0))).isInstanceOf(TypeImplementationDependency.class);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Parametric scalar with type injected though constructor");
    }

    @Test
    public void testFixedTypeParameterParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(FixedTypeParameterScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        AnnotationEngineAssertions.assertImplementationCount(scalar, 1, 0, 0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Parametric scalar that uses TypeParameter with fixed type");
    }

    @Test
    public void testPartiallyFixedTypeParameterParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T1").typeVariable("T2").returnType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(PartiallyFixedTypeParameterScalarFunction.class);
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        AnnotationEngineAssertions.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assertions.assertThat((int)parametricScalarImplementationChoices.size()).isEqualTo(1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assertions.assertThat((int)dependencies.size()).isEqualTo(1);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assertions.assertThat((Object)functionMetadata.getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((boolean)functionMetadata.isDeterministic()).isTrue();
        Assertions.assertThat((boolean)functionMetadata.isHidden()).isFalse();
        Assertions.assertThat((String)functionMetadata.getDescription()).isEqualTo("Parametric scalar that uses TypeParameter with partially fixed type");
    }

    @ScalarFunction(value="single_implementation_parametric_scalar")
    @Description(value="Simple scalar with single implementation based on class")
    public static final class SingleImplementationScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="hidden_scalar_function", hidden=true)
    @Description(value="Simple scalar with hidden property set")
    public static final class HiddenScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="non_deterministic_scalar_function", deterministic=false)
    @Description(value="Simple scalar with deterministic property reset")
    public static final class NonDeterministicScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable")
    @Description(value="Simple scalar with nullable primitive")
    public static final class WithNullablePrimitiveArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlType(value="double") double v2, @IsNull boolean v2isNull) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable_complex")
    @Description(value="Simple scalar with nullable complex type")
    public static final class WithNullableComplexArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlNullable @SqlType(value="double") Double v2) {
            return v;
        }
    }

    public static final class StaticMethodScalarFunction {
        @ScalarFunction(value="static_method_scalar")
        @Description(value="Simple scalar with single implementation based on method")
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    public static final class MultiScalarFunction {
        @ScalarFunction(value="static_method_scalar_1")
        @Description(value="Simple scalar with single implementation based on method 1")
        @SqlType(value="double")
        public static double fun1(@SqlType(value="double") double v) {
            return v;
        }

        @ScalarFunction(value="static_method_scalar_2", hidden=true, deterministic=false)
        @Description(value="Simple scalar with single implementation based on method 2")
        @SqlType(value="bigint")
        public static long fun2(@SqlType(value="bigint") long v) {
            return v;
        }
    }

    @ScalarFunction(value="parametric_scalar")
    @Description(value="Parametric scalar description")
    public static final class ParametricScalarFunction {
        @SqlType(value="T")
        @TypeParameter(value="T")
        public static double fun(@SqlType(value="T") double v) {
            return v;
        }

        @SqlType(value="T")
        @TypeParameter(value="T")
        public static long fun(@SqlType(value="T") long v) {
            return v;
        }
    }

    @ScalarFunction(value="with_exact_scalar")
    @Description(value="Parametric scalar with exact and generic implementations")
    public static final class ComplexParametricScalarFunction {
        @SqlType(value="boolean")
        @LiteralParameters(value={"x"})
        public static boolean fun1(@SqlType(value="array(varchar(x))") Block array) {
            return true;
        }

        @SqlType(value="boolean")
        public static boolean fun2(@SqlType(value="array(varchar(17))") Block array) {
            return true;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject")
    @Description(value="Parametric scalar with literal injected")
    public static final class SimpleInjectionScalarFunction {
        @SqlType(value="bigint")
        @LiteralParameters(value={"x"})
        public static long fun(@LiteralParameter(value="x") Long literalParam, @SqlType(value="varchar(x)") Slice val) {
            return literalParam;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject_constructor")
    @Description(value="Parametric scalar with type injected though constructor")
    public static class ConstructorInjectionScalarFunction {
        @TypeParameter(value="T")
        public ConstructorInjectionScalarFunction(@TypeParameter(value="T") Type type) {
        }

        @SqlType(value="bigint")
        @TypeParameter(value="T")
        public long fun(@SqlType(value="array(T)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funBigint(@SqlType(value="array(bigint)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funDouble(@SqlType(value="array(double)") Block val) {
            return 17L;
        }
    }

    @ScalarFunction(value="fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with fixed type")
    public static final class FixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        public static long fun(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    @ScalarFunction(value="partially_fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with partially fixed type")
    public static final class PartiallyFixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static long fun(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }
}

