/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.RowIdComparisonStrategy;
import io.trino.operator.RowReferencePageManager;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRowReferencePageManager {
    @Test
    public void testEmptyPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 0L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assertions.assertThat((boolean)cursor.advance()).isFalse();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RowReferencePageManager.LoadCursor)cursor).allocateRowId()).isInstanceOf(IllegalStateException.class)).hasMessage("Not yet advanced");
        }
        Assertions.assertThat((long)pageManager.getPageBytes()).isEqualTo(0L);
    }

    @Test
    public void testSinglePageRowIds() {
        long id3;
        long id1;
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        RowIdComparisonStrategy strategy = (rowId1, rowId2) -> {
            long value1 = TestRowReferencePageManager.extractValue(pageManager, rowId1);
            long value2 = TestRowReferencePageManager.extractValue(pageManager, rowId2);
            return Long.compare(value1, value2);
        };
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 4L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            id0 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            Assertions.assertThat((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0).isTrue();
            id1 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id1)).isEqualTo(1L);
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            Assertions.assertThat((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((cursor.compareTo(strategy, id1) > 0 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            Assertions.assertThat((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((cursor.compareTo(strategy, id1) > 0 ? 1 : 0) != 0).isTrue();
            id3 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id3)).isEqualTo(3L);
            Assertions.assertThat((long)pageManager.getPageBytes()).isEqualTo(0L);
        }
        Assertions.assertThat((pageManager.getPageBytes() > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id1)).isEqualTo(1L);
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id3)).isEqualTo(3L);
    }

    @Test
    public void testMultiplePageRowIds() {
        long id1;
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        RowIdComparisonStrategy strategy = (rowId1, rowId2) -> {
            long value1 = TestRowReferencePageManager.extractValue(pageManager, rowId1);
            long value2 = TestRowReferencePageManager.extractValue(pageManager, rowId2);
            return Long.compare(value1, value2);
        };
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 1L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            id0 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
            Assertions.assertThat((boolean)cursor.advance()).isFalse();
            Assertions.assertThat((long)pageManager.getPageBytes()).isEqualTo(0L);
        }
        long pageBytes1 = pageManager.getPageBytes();
        Assertions.assertThat((pageBytes1 > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
        page = TestRowReferencePageManager.createBigIntSingleBlockPage(1L, 2L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            Assertions.assertThat((cursor.compareTo(strategy, id0) > 0 ? 1 : 0) != 0).isTrue();
            id1 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id1)).isEqualTo(1L);
            Assertions.assertThat((boolean)cursor.advance()).isFalse();
            Assertions.assertThat((long)pageManager.getPageBytes()).isEqualTo(pageBytes1);
        }
        Assertions.assertThat((pageManager.getPageBytes() > pageBytes1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id1)).isEqualTo(1L);
    }

    @Test
    public void testSkipCompaction() {
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            id0 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
            Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(0);
        }
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
        long pageBytesBeforeCompaction = pageManager.getPageBytes();
        Assertions.assertThat((pageBytesBeforeCompaction > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(1);
        pageManager.compactIfNeeded();
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(0);
        Assertions.assertThat((pageManager.getPageBytes() < pageBytesBeforeCompaction ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
    }

    @Test
    public void testDereferenceCompaction() {
        long id0;
        RowReferencePageManager pageManager = new RowReferencePageManager();
        ArrayList<Long> rowIdsToDereference = new ArrayList<Long>();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (Object cursor = pageManager.add(page);){
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            id0 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
            while (cursor.advance()) {
                rowIdsToDereference.add(cursor.allocateRowId());
            }
        }
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(0);
        cursor = rowIdsToDereference.iterator();
        while (cursor.hasNext()) {
            long rowId = (Long)cursor.next();
            pageManager.dereference(rowId);
        }
        long pageBytesBeforeCompaction = pageManager.getPageBytes();
        Assertions.assertThat((pageBytesBeforeCompaction > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(1);
        pageManager.compactIfNeeded();
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(0);
        Assertions.assertThat((pageManager.getPageBytes() < pageBytesBeforeCompaction ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
    }

    @Test
    public void testSkipFullPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        RowReferencePageManager.LoadCursor cursor = pageManager.add(page);
        if (cursor != null) {
            cursor.close();
        }
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(0);
        Assertions.assertThat((long)pageManager.getPageBytes()).isEqualTo(0L);
    }

    @Test
    public void testDereferenceFullPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        ArrayList<Long> rowIdsToDereference = new ArrayList<Long>();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            while (cursor.advance()) {
                rowIdsToDereference.add(cursor.allocateRowId());
            }
        }
        Iterator iterator = rowIdsToDereference.iterator();
        while (iterator.hasNext()) {
            long rowId = (Long)iterator.next();
            pageManager.dereference(rowId);
        }
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(0);
        Assertions.assertThat((long)pageManager.getPageBytes()).isEqualTo(0L);
    }

    @Test
    public void testInlineDereferenceFullPage() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 100L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            while (cursor.advance()) {
                pageManager.dereference(cursor.allocateRowId());
            }
        }
        Assertions.assertThat((int)pageManager.getCompactionCandidateCount()).isEqualTo(0);
        Assertions.assertThat((long)pageManager.getPageBytes()).isEqualTo(0L);
    }

    @Test
    public void testRowIdRecycling() {
        RowReferencePageManager pageManager = new RowReferencePageManager();
        Page page = TestRowReferencePageManager.createBigIntSingleBlockPage(0L, 3L);
        try (RowReferencePageManager.LoadCursor cursor = pageManager.add(page);){
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            long id0 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id0)).isEqualTo(0L);
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            long id1 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id1)).isEqualTo(1L);
            pageManager.dereference(id0);
            Assertions.assertThat((boolean)cursor.advance()).isTrue();
            long id2 = cursor.allocateRowId();
            Assertions.assertThat((long)TestRowReferencePageManager.extractValue(pageManager, id2)).isEqualTo(2L);
            Assertions.assertThat((long)id0).isEqualTo(id2);
        }
    }

    private static long extractValue(RowReferencePageManager pageManager, long rowId) {
        Page page = pageManager.getPage(rowId);
        int position = pageManager.getPosition(rowId);
        return BigintType.BIGINT.getLong(page.getBlock(0), position);
    }

    private static Page createBigIntSingleBlockPage(long startInclusive, long endExclusive) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(Math.toIntExact(endExclusive - startInclusive));
        for (long i = startInclusive; i < endExclusive; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, i);
        }
        Block block = blockBuilder.build();
        return new Page(new Block[]{block});
    }
}

