/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.ApproximateCountDistinctAggregation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestApproximateCountDistinctAggregations {
    @Test
    public void testStandardErrorToBuckets() {
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0326)).isEqualTo(1024);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0325)).isEqualTo(1024);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0324)).isEqualTo(2048);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0231)).isEqualTo(2048);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.023)).isEqualTo(2048);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0229)).isEqualTo(4096);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0164)).isEqualTo(4096);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0163)).isEqualTo(4096);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0162)).isEqualTo(8192);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0116)).isEqualTo(8192);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0115)).isEqualTo(8192);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0114)).isEqualTo(16384);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.008126)).isEqualTo(16384);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.008125)).isEqualTo(16384);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.008124)).isEqualTo(32768);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.00576)).isEqualTo(32768);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.00575)).isEqualTo(32768);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.00574)).isEqualTo(65536);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0040626)).isEqualTo(65536);
        Assertions.assertThat((int)ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0040625)).isEqualTo(65536);
    }

    @Test
    public void testStandardErrorToBucketsBounds() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.0040624)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> ApproximateCountDistinctAggregation.standardErrorToBuckets((double)0.26001)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }
}

