/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.AbstractTestApproximateSetGeneric;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class TestApproximateSetGenericVarchar
extends AbstractTestApproximateSetGeneric {
    @Override
    protected Type getValueType() {
        return VarcharType.VARCHAR;
    }

    @Override
    protected Object randomValue() {
        int length = ThreadLocalRandom.current().nextInt(100);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(Character.toString(ThreadLocalRandom.current().nextInt(1000)));
        }
        byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
        return Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    protected List<Object> getResultStabilityTestSample() {
        return ImmutableList.of((Object)Slices.utf8Slice((String)""), (Object)Slices.utf8Slice((String)"\u0105\u0119\u0144\u2202\u2202\u0144\u0144d"), (Object)Slices.utf8Slice((String)"ala ma kota"), (Object)Slices.utf8Slice((String)"fedfd fd fd fd f df df "), (Object)Slices.utf8Slice((String)"aaaaaaaaaaaaaaaa"), (Object)Slices.utf8Slice((String)"aaaaaaaaaaaa"), (Object)Slices.utf8Slice((String)"aaaaaaaaaaaa"), (Object)Slices.utf8Slice((String)"bbbb"), (Object)Slices.utf8Slice((String)"some-non-bmp-\ud83d\ude81"), (Object)Slices.utf8Slice((String)"cccccc"));
    }

    @Override
    protected String getResultStabilityExpected() {
        return "020C0900400F3E32C2EC5B7E80D0F8B7C04DD5B9C0B200C9807035D782C8F5DF00DB46EF012B5AFD";
    }
}

