/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import io.trino.SequencePageBuilder;
import io.trino.execution.buffer.PageSplitterUtil;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.PageAssertions;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorAssertion;
import io.trino.operator.project.MergePages;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMergePages {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE);

    @Test
    public void testMinPageSizeThreshold() {
        Page page = SequencePageBuilder.createSequencePage(TYPES, 10);
        WorkProcessor mergePages = MergePages.mergePages(TYPES, (long)page.getSizeInBytes(), (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, TestMergePages.pagesSource(page), (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        WorkProcessorAssertion.validateResult(mergePages, actualPage -> PageAssertions.assertPageEquals(TYPES, actualPage, page));
        WorkProcessorAssertion.assertFinishes(mergePages);
    }

    @Test
    public void testMinRowCountThreshold() {
        Page page = SequencePageBuilder.createSequencePage(TYPES, 10);
        WorkProcessor mergePages = MergePages.mergePages(TYPES, (long)0x100000L, (int)page.getPositionCount(), (int)Integer.MAX_VALUE, TestMergePages.pagesSource(page), (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        WorkProcessorAssertion.validateResult(mergePages, actualPage -> PageAssertions.assertPageEquals(TYPES, actualPage, page));
        WorkProcessorAssertion.assertFinishes(mergePages);
    }

    @Test
    public void testMinRowCountThresholdWithLazyPages() {
        Page page = SequencePageBuilder.createSequencePage(TYPES, 10);
        LazyBlock channel1 = TestMergePages.lazyWrapper(page.getBlock(0));
        LazyBlock channel2 = TestMergePages.lazyWrapper(page.getBlock(1));
        LazyBlock channel3 = TestMergePages.lazyWrapper(page.getBlock(2));
        page = new Page(new Block[]{channel1, channel2, channel3});
        WorkProcessor mergePages = MergePages.mergePages(TYPES, (long)0x100000L, (int)(page.getPositionCount() * 2), (int)Integer.MAX_VALUE, TestMergePages.pagesSource(page), (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        Assertions.assertThat((boolean)mergePages.process()).isTrue();
        Assertions.assertThat((boolean)mergePages.isFinished()).isFalse();
        Page result = (Page)mergePages.getResult();
        Assertions.assertThat((boolean)channel1.isLoaded()).isFalse();
        Assertions.assertThat((boolean)channel2.isLoaded()).isFalse();
        Assertions.assertThat((boolean)channel3.isLoaded()).isFalse();
        PageAssertions.assertPageEquals(TYPES, result, page);
    }

    @Test
    public void testBufferSmallPages() {
        int singlePageRowCount = 10;
        Page page = SequencePageBuilder.createSequencePage(TYPES, singlePageRowCount * 2);
        List splits = PageSplitterUtil.splitPage((Page)page, (long)(page.getSizeInBytes() / 2L));
        WorkProcessor mergePages = MergePages.mergePages(TYPES, (long)(page.getSizeInBytes() + 1L), (int)(page.getPositionCount() + 1), (int)Integer.MAX_VALUE, TestMergePages.pagesSource((Page)splits.get(0), (Page)splits.get(1)), (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        WorkProcessorAssertion.validateResult(mergePages, actualPage -> PageAssertions.assertPageEquals(TYPES, actualPage, page));
        WorkProcessorAssertion.assertFinishes(mergePages);
    }

    @Test
    public void testFlushOnBigPage() {
        Page smallPage = SequencePageBuilder.createSequencePage(TYPES, 10);
        Page bigPage = SequencePageBuilder.createSequencePage(TYPES, 100);
        WorkProcessor mergePages = MergePages.mergePages(TYPES, (long)bigPage.getSizeInBytes(), (int)bigPage.getPositionCount(), (int)Integer.MAX_VALUE, TestMergePages.pagesSource(smallPage, bigPage), (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        WorkProcessorAssertion.validateResult(mergePages, actualPage -> PageAssertions.assertPageEquals(TYPES, actualPage, smallPage));
        WorkProcessorAssertion.validateResult(mergePages, actualPage -> PageAssertions.assertPageEquals(TYPES, actualPage, bigPage));
        WorkProcessorAssertion.assertFinishes(mergePages);
    }

    @Test
    public void testFlushOnFullPage() {
        int singlePageRowCount = 10;
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        Page page = SequencePageBuilder.createSequencePage((List<? extends Type>)types, singlePageRowCount * 2);
        List splits = PageSplitterUtil.splitPage((Page)page, (long)(page.getSizeInBytes() / 2L));
        WorkProcessor mergePages = MergePages.mergePages((Iterable)types, (long)(page.getSizeInBytes() / 2L + 1L), (int)(page.getPositionCount() / 2 + 1), (int)Math.toIntExact(page.getSizeInBytes()), TestMergePages.pagesSource((Page)splits.get(0), (Page)splits.get(1), (Page)splits.get(0), (Page)splits.get(1)), (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        WorkProcessorAssertion.validateResult(mergePages, arg_0 -> TestMergePages.lambda$testFlushOnFullPage$5((List)types, page, arg_0));
        WorkProcessorAssertion.validateResult(mergePages, arg_0 -> TestMergePages.lambda$testFlushOnFullPage$6((List)types, page, arg_0));
        WorkProcessorAssertion.assertFinishes(mergePages);
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }

    private static WorkProcessor<Page> pagesSource(Page ... pages) {
        return WorkProcessor.fromIterable((Iterable)ImmutableList.copyOf((Object[])pages));
    }

    private static /* synthetic */ void lambda$testFlushOnFullPage$6(List types, Page page, Page actualPage) {
        PageAssertions.assertPageEquals(types, actualPage, page);
    }

    private static /* synthetic */ void lambda$testFlushOnFullPage$5(List types, Page page, Page actualPage) {
        PageAssertions.assertPageEquals(types, actualPage, page);
    }
}

