/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.operator.project.SelectedPositions;
import io.trino.testing.DataProviders;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSelectedPositions {
    private static final Random RANDOM = new Random(38844897L);
    private static final SelectedPositions EMPTY_LIST = SelectedPositions.positionsList((int[])new int[10], (int)5, (int)0);
    private static final SelectedPositions EMPTY_RANGE = SelectedPositions.positionsRange((int)13, (int)0);
    private static final SelectedPositions NON_EMPTY_LIST = SelectedPositions.positionsList((int[])new int[10], (int)5, (int)5);
    private static final SelectedPositions NON_EMPTY_RANGE = SelectedPositions.positionsRange((int)13, (int)7);

    @Test
    public void testEmpty() {
        Assertions.assertThat((Object)EMPTY_LIST.union(EMPTY_LIST)).isEqualTo((Object)EMPTY_LIST);
        Assertions.assertThat((Object)EMPTY_LIST.union(EMPTY_RANGE)).isEqualTo((Object)EMPTY_LIST);
        Assertions.assertThat((Object)EMPTY_RANGE.union(EMPTY_LIST)).isEqualTo((Object)EMPTY_RANGE);
        Assertions.assertThat((Object)EMPTY_RANGE.union(EMPTY_RANGE)).isEqualTo((Object)EMPTY_RANGE);
        Assertions.assertThat((Object)EMPTY_LIST.union(NON_EMPTY_LIST)).isEqualTo((Object)NON_EMPTY_LIST);
        Assertions.assertThat((Object)EMPTY_LIST.union(NON_EMPTY_RANGE)).isEqualTo((Object)NON_EMPTY_RANGE);
        Assertions.assertThat((Object)NON_EMPTY_LIST.union(EMPTY_LIST)).isEqualTo((Object)NON_EMPTY_LIST);
        Assertions.assertThat((Object)NON_EMPTY_RANGE.union(EMPTY_LIST)).isEqualTo((Object)NON_EMPTY_RANGE);
        Assertions.assertThat((Object)EMPTY_RANGE.union(NON_EMPTY_RANGE)).isEqualTo((Object)NON_EMPTY_RANGE);
        Assertions.assertThat((Object)NON_EMPTY_RANGE.union(EMPTY_LIST)).isEqualTo((Object)NON_EMPTY_RANGE);
        Assertions.assertThat((Object)EMPTY_LIST.difference(NON_EMPTY_LIST)).isEqualTo((Object)EMPTY_LIST);
        Assertions.assertThat((Object)NON_EMPTY_LIST.difference(EMPTY_LIST)).isEqualTo((Object)NON_EMPTY_LIST);
        Assertions.assertThat((Object)EMPTY_RANGE.difference(NON_EMPTY_RANGE)).isEqualTo((Object)EMPTY_RANGE);
        Assertions.assertThat((Object)NON_EMPTY_RANGE.difference(EMPTY_RANGE)).isEqualTo((Object)NON_EMPTY_RANGE);
    }

    @ParameterizedTest
    @MethodSource(value={"inputSizes"})
    public void testListsUnionAndDifference(int size, int maxGroupSize) {
        int[] positions = TestSelectedPositions.generateList(size, maxGroupSize);
        SelectedPositions listA = SelectedPositions.positionsList((int[])positions, (int)0, (int)(size / 2));
        SelectedPositions listB = SelectedPositions.positionsList((int[])positions, (int)(size / 2), (int)(size - size / 2));
        TestSelectedPositions.assertUnionAndDifference(listA, listB);
        TestSelectedPositions.assertUnionAndDifference(listA, listA);
        TestSelectedPositions.assertUnionAndDifference(listB, listB);
        listA = SelectedPositions.positionsList((int[])positions, (int)0, (int)(3 * size / 4));
        listB = SelectedPositions.positionsList((int[])positions, (int)(size / 4), (int)(size - size / 4));
        TestSelectedPositions.assertUnionAndDifference(listA, listB);
        listB = SelectedPositions.positionsList((int[])positions, (int)(size / 4), (int)(size / 4));
        TestSelectedPositions.assertUnionAndDifference(listA, listB);
    }

    @ParameterizedTest
    @MethodSource(value={"inputSizes"})
    public void testListRangeUnionAndDifference(int size, int maxGroupSize) {
        int[] positions = TestSelectedPositions.generateList(size, maxGroupSize);
        SelectedPositions list = SelectedPositions.positionsList((int[])positions, (int)(size / 2), (int)(size / 2));
        SelectedPositions range = SelectedPositions.positionsRange((int)0, (int)positions[size / 4]);
        TestSelectedPositions.assertUnionAndDifference(list, range);
        list = SelectedPositions.positionsList((int[])positions, (int)0, (int)size);
        range = SelectedPositions.positionsRange((int)(list.getPositions()[list.getOffset() + list.size()] + 1), (int)size);
        TestSelectedPositions.assertUnionAndDifference(list, range);
        list = SelectedPositions.positionsList((int[])positions, (int)(size / 4), (int)(size / 2));
        range = SelectedPositions.positionsRange((int)positions[0], (int)(list.getPositions()[list.size() - 1] - positions[0]));
        TestSelectedPositions.assertUnionAndDifference(list, range);
        range = SelectedPositions.positionsRange((int)list.getPositions()[list.getOffset()], (int)(positions[size - 1] - list.getPositions()[list.getOffset()]));
        TestSelectedPositions.assertUnionAndDifference(list, range);
        list = SelectedPositions.positionsList((int[])positions, (int)0, (int)size);
        range = SelectedPositions.positionsRange((int)positions[0], (int)(positions[size - 1] - positions[0]));
        TestSelectedPositions.assertUnionAndDifference(list, range);
        for (int position = 0; position < size; ++position) {
            positions[position] = position;
        }
        list = SelectedPositions.positionsList((int[])positions, (int)0, (int)size);
        range = SelectedPositions.positionsRange((int)0, (int)size);
        TestSelectedPositions.assertUnionAndDifference(list, range);
    }

    @Test
    public void testRangesUnionAndDifference() {
        SelectedPositions rangeA = SelectedPositions.positionsRange((int)0, (int)1024);
        SelectedPositions rangeB = SelectedPositions.positionsRange((int)2000, (int)100);
        TestSelectedPositions.assertUnionAndDifference(rangeA, rangeB);
        TestSelectedPositions.assertUnionAndDifference(rangeA, rangeA);
        TestSelectedPositions.assertUnionAndDifference(rangeB, rangeB);
        rangeA = SelectedPositions.positionsRange((int)0, (int)1024);
        rangeB = SelectedPositions.positionsRange((int)1000, (int)1000);
        TestSelectedPositions.assertUnionAndDifference(rangeA, rangeB);
        rangeB = SelectedPositions.positionsRange((int)300, (int)700);
        TestSelectedPositions.assertUnionAndDifference(rangeA, rangeB);
    }

    private static Object[][] inputSizes() {
        return DataProviders.cartesianProduct((Object[][][])new Object[][][]{(Object[][])Stream.of(1024, 8096, 65536).collect(DataProviders.toDataProvider()), (Object[][])Stream.of(1, 10, 100, 200, 500).collect(DataProviders.toDataProvider())});
    }

    private static int[] generateList(int size, int maxGroupSize) {
        IntArrayList groupedList = new IntArrayList();
        int position = 0;
        while (groupedList.size() < size) {
            boolean skip = RANDOM.nextBoolean();
            int groupSize = Math.min(RANDOM.nextInt(1, maxGroupSize + 1), size - groupedList.size());
            if (!skip) {
                for (int i = 0; i < groupSize; ++i) {
                    groupedList.add(position + i);
                }
            }
            position += groupSize;
        }
        return groupedList.elements();
    }

    private static void assertUnionAndDifference(SelectedPositions positionsA, SelectedPositions positionsB) {
        TestSelectedPositions.assertUnion(positionsA, positionsB);
        TestSelectedPositions.assertUnion(positionsB, positionsA);
        TestSelectedPositions.assertDifference(positionsA, positionsB);
        TestSelectedPositions.assertDifference(positionsB, positionsA);
    }

    private static void assertUnion(SelectedPositions positionsA, SelectedPositions positionsB) {
        SelectedPositions result = positionsA.union(positionsB);
        Assertions.assertThat(TestSelectedPositions.toSet(result)).isEqualTo((Object)Sets.union(TestSelectedPositions.toSet(positionsA), TestSelectedPositions.toSet(positionsB)));
        if (result.isList()) {
            int[] activePositions = new int[result.size()];
            System.arraycopy(result.getPositions(), result.getOffset(), activePositions, 0, result.size());
            Assertions.assertThat((int[])activePositions).isSorted();
            Assertions.assertThat((int[])activePositions).doesNotHaveDuplicates();
        }
    }

    private static void assertDifference(SelectedPositions positionsA, SelectedPositions positionsB) {
        SelectedPositions result = positionsA.difference(positionsB);
        Assertions.assertThat(TestSelectedPositions.toSet(result)).isEqualTo((Object)Sets.difference(TestSelectedPositions.toSet(positionsA), TestSelectedPositions.toSet(positionsB)));
        if (result.isList()) {
            int[] activePositions = new int[result.size()];
            System.arraycopy(result.getPositions(), result.getOffset(), activePositions, 0, result.size());
            Assertions.assertThat((int[])activePositions).isSorted();
            Assertions.assertThat((int[])activePositions).doesNotHaveDuplicates();
        }
    }

    private static Set<Integer> toSet(SelectedPositions positions) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (positions.isList()) {
            for (int index = positions.getOffset(); index < positions.getOffset() + positions.size(); ++index) {
                builder.add((Object)positions.getPositions()[index]);
            }
        } else {
            for (int position = positions.getOffset(); position < positions.getOffset() + positions.size(); ++position) {
                builder.add((Object)position);
            }
        }
        return builder.build();
    }
}

