/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.jmh.Benchmarks;
import io.trino.operator.scalar.TypeOperatorBenchmarkUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=4)
@Warmup(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=15, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkHashCodeOperator {
    private static final int POSITIONS = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public long hashOperator(BenchmarkData data) throws Throwable {
        return data.getHashBlock().invokeExact(data.getBlock());
    }

    @Test
    public void test() throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.hashOperator(data);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkHashCodeOperator.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "VARCHAR", "DOUBLE", "BOOLEAN"})
        private String type = "BIGINT";
        private MethodHandle hashBlock;
        private Block block;

        @Setup
        public void setup() {
            Type type = TypeOperatorBenchmarkUtil.toType(this.type);
            this.block = BenchmarkData.createChannel(10000, type);
            this.hashBlock = TypeOperatorBenchmarkUtil.getHashCodeBlockMethod(type);
        }

        private static Block createChannel(int positionCount, Type type) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                TypeOperatorBenchmarkUtil.addElement(type, random, blockBuilder);
            }
            return blockBuilder.build();
        }

        public MethodHandle getHashBlock() {
            return this.hashBlock;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

