/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkRowToRowCast {
    private static final int POSITION_COUNT = 100000;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkRowToRowCast().benchmark(data);
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkRowToRowCast().benchmark(data);
        Benchmarks.benchmark(BenchmarkRowToRowCast.class, (WarmupMode)WarmupMode.INDI).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final List<Type> fromFieldTypes = ImmutableList.of((Object)VarcharType.createVarcharType((int)20), (Object)BigintType.BIGINT);
        private static final List<Type> toFieldTypes = ImmutableList.of((Object)VarcharType.createVarcharType((int)30), (Object)BigintType.BIGINT);
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(functionResolution.getCoercion((Type)RowType.anonymous(toFieldTypes), (Type)RowType.anonymous(fromFieldTypes)), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)RowType.anonymous(toFieldTypes)))));
            this.pageProcessor = (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)projections).get();
            Block[] fieldBlocks = (Block[])fromFieldTypes.stream().map(type -> BenchmarkData.createBlock(100000, type)).toArray(Block[]::new);
            RowBlock rowBlock = RowBlock.fromFieldBlocks((int)100000, (Block[])fieldBlocks);
            this.page = new Page(new Block[]{rowBlock});
        }

        private static Block createBlock(int positionCount, Type type) {
            BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
            if (type instanceof VarcharType) {
                for (int i = 0; i < positionCount; ++i) {
                    type.writeSlice(blockBuilder, Slices.utf8Slice((String)String.valueOf(ThreadLocalRandom.current().nextInt())));
                }
            } else if (type == BigintType.BIGINT) {
                for (int i = 0; i < positionCount; ++i) {
                    type.writeLong(blockBuilder, ThreadLocalRandom.current().nextLong());
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

