/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
final class TestArrayVectorFunctions {
    private final QueryAssertions assertions = new QueryAssertions();

    TestArrayVectorFunctions() {
    }

    @AfterAll
    void teardown() {
        this.assertions.close();
    }

    @Test
    void testEuclideanDistance() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[1]", "ARRAY[2]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[1, 2]", "ARRAY[3, 4]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.8284271247461903);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[4, 5, 6]", "ARRAY[4, 5, 6]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '1.1', REAL '2.2', REAL '3.3']", "ARRAY[REAL '4.4', REAL '5.5', REAL '6.6']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(5.715767651212193);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[DOUBLE '1.1', DOUBLE '2.2', DOUBLE '3.3']", "ARRAY[DOUBLE '4.4', DOUBLE '5.5', DOUBLE '6.6']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(5.715767664977295);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[1.1, 2.2, 3.3]", "ARRAY[4.4, 5.5, 6.6]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(5.715767664977295);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[]", "ARRAY[]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '-3.4028235e+38f']", "ARRAY[REAL '-3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '-3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(6.805646932770577E38);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '-3.4028235e+38f']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(6.805646932770577E38);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '-1.4E-45']", "ARRAY[REAL '-1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '-1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.8E-45f);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '-1.4E-45']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.8E-45f);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(3.4028234663852886E38);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(3.4028234663852886E38);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[DOUBLE '1.7976931348623157E+309']", "ARRAY[DOUBLE '1.7976931348623157E+309']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[DOUBLE '-1.7976931348623157E+308']", "ARRAY[DOUBLE '-1.7976931348623157E+308']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[DOUBLE '1.7976931348623157E+309']", "ARRAY[DOUBLE '-1.7976931348623157E+308']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[DOUBLE '-1.7976931348623157E+308']", "ARRAY[DOUBLE '1.7976931348623157E+309']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[1]", "ARRAY[nan()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[nan()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[1]", "ARRAY[-infinity()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[-infinity()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[1]", "ARRAY[infinity()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("euclidean_distance", "ARRAY[infinity()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("euclidean_distance", "ARRAY[]", "ARRAY[1]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("euclidean_distance", "ARRAY[1]", "ARRAY[]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("euclidean_distance", "ARRAY[1]", "ARRAY[1, 2]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("euclidean_distance", "ARRAY[1, 2]", "ARRAY[1]")::evaluate).hasMessage("The arguments must have the same length");
    }

    @Test
    void testDotProduct() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[1]", "ARRAY[2]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[1, 2]", "ARRAY[3, 4]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(11.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[4, 5, 6]", "ARRAY[4, 5, 6]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(77.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '1.1', REAL '2.2', REAL '3.3']", "ARRAY[REAL '4.4', REAL '5.5', REAL '6.6']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(38.719999842643745);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[DOUBLE '1.1', DOUBLE '2.2', DOUBLE '3.3']", "ARRAY[DOUBLE '4.4', DOUBLE '5.5', DOUBLE '6.6']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(38.72);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[1.1, 2.2, 3.3]", "ARRAY[4.4, 5.5, 6.6]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(38.72);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[]", "ARRAY[]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(1.1579207543382391E77);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '-3.4028235e+38f']", "ARRAY[REAL '-3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(1.1579207543382391E77);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '-3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(-1.1579207543382391E77);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '-3.4028235e+38f']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(-1.1579207543382391E77);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(1.9636373861190906E-90);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '-1.4E-45']", "ARRAY[REAL '-1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(1.9636373861190906E-90);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '-1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(-1.9636373861190906E-90);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '-1.4E-45']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(-1.9636373861190906E-90);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(4.7683712978141557E-7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(4.7683712978141557E-7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[DOUBLE '1.7976931348623157E+309']", "ARRAY[DOUBLE '1.7976931348623157E+309']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[DOUBLE '-1.7976931348623157E+308']", "ARRAY[DOUBLE '-1.7976931348623157E+308']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[DOUBLE '1.7976931348623157E+309']", "ARRAY[DOUBLE '-1.7976931348623157E+308']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[DOUBLE '-1.7976931348623157E+308']", "ARRAY[DOUBLE '1.7976931348623157E+309']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[1]", "ARRAY[nan()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[nan()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[1]", "ARRAY[-infinity()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[-infinity()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[1]", "ARRAY[+infinity()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("dot_product", "ARRAY[infinity()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("dot_product", "ARRAY[]", "ARRAY[1]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("dot_product", "ARRAY[1]", "ARRAY[]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("dot_product", "ARRAY[1]", "ARRAY[1, 2]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("dot_product", "ARRAY[1, 2]", "ARRAY[1]")::evaluate).hasMessage("The arguments must have the same length");
    }

    @Test
    void testCosineDistance() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[1]", "ARRAY[2]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[1, 2]", "ARRAY[3, 4]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.01613008990009257);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[4, 5, 6]", "ARRAY[4, 5, 6]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '1.1', REAL '2.2', REAL '3.3']", "ARRAY[REAL '4.4', REAL '5.5', REAL '6.6']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.025368154060122383);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[DOUBLE '1.1', DOUBLE '2.2', DOUBLE '3.3']", "ARRAY[DOUBLE '4.4', DOUBLE '5.5', DOUBLE '6.6']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.025368153802923676);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[1.1, 2.2, 3.3]", "ARRAY[4.4, 5.5, 6.6]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.025368153802923676);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '-3.4028235e+38f']", "ARRAY[REAL '-3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '-3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '-3.4028235e+38f']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '-1.4E-45']", "ARRAY[REAL '-1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '-1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '-1.4E-45']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '3.4028235e+38f']", "ARRAY[REAL '1.4E-45']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[REAL '1.4E-45']", "ARRAY[REAL '3.4028235e+38f']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[DOUBLE '1.7976931348623157E+309']", "ARRAY[DOUBLE '1.7976931348623157E+309']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[DOUBLE '-1.7976931348623157E+308']", "ARRAY[DOUBLE '-1.7976931348623157E+308']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[DOUBLE '1.7976931348623157E+309']", "ARRAY[DOUBLE '-1.7976931348623157E+308']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[DOUBLE '-1.7976931348623157E+308']", "ARRAY[DOUBLE '1.7976931348623157E+309']")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[1]", "ARRAY[nan()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[nan()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[1]", "ARRAY[-infinity()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[-infinity()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[1]", "ARRAY[infinity()]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cosine_distance", "ARRAY[infinity()]", "ARRAY[1]")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("cosine_distance", "ARRAY[]", "ARRAY[]")::evaluate).hasMessage("Vector magnitude cannot be zero");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("cosine_distance", "ARRAY[]", "ARRAY[1]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("cosine_distance", "ARRAY[1]", "ARRAY[]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("cosine_distance", "ARRAY[1]", "ARRAY[1, 2]")::evaluate).hasMessage("The arguments must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("cosine_distance", "ARRAY[1, 2]", "ARRAY[1]")::evaluate).hasMessage("The arguments must have the same length");
    }
}

