/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.ColorFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestColorFunctions {
    @Test
    public void testParseRgb() {
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#000"))).isEqualTo(0);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#FFF"))).isEqualTo(0xFFFFFF);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#F00"))).isEqualTo(0xFF0000);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#0F0"))).isEqualTo(65280);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#00F"))).isEqualTo(255);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#700"))).isEqualTo(0x770000);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#070"))).isEqualTo(30464);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#007"))).isEqualTo(119);
        Assertions.assertThat((int)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#cde"))).isEqualTo(0xCCDDEE);
    }

    @Test
    public void testGetComponent() {
        Assertions.assertThat((int)ColorFunctions.getRed((long)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#789")))).isEqualTo(119);
        Assertions.assertThat((int)ColorFunctions.getGreen((long)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#789")))).isEqualTo(136);
        Assertions.assertThat((int)ColorFunctions.getBlue((long)ColorFunctions.parseRgb((Slice)Slices.utf8Slice((String)"#789")))).isEqualTo(153);
    }

    @Test
    public void testToRgb() {
        Assertions.assertThat((long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L)).isEqualTo(0xFF0000L);
        Assertions.assertThat((long)ColorFunctions.rgb((long)0L, (long)255L, (long)0L)).isEqualTo(65280L);
        Assertions.assertThat((long)ColorFunctions.rgb((long)0L, (long)0L, (long)255L)).isEqualTo(255L);
    }

    @Test
    public void testColor() {
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"black"))).isEqualTo(-1L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red"))).isEqualTo(-2L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"green"))).isEqualTo(-3L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"yellow"))).isEqualTo(-4L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"blue"))).isEqualTo(-5L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"magenta"))).isEqualTo(-6L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"cyan"))).isEqualTo(-7L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"white"))).isEqualTo(-8L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00"))).isEqualTo(0xFF0000L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0"))).isEqualTo(65280L);
        Assertions.assertThat((long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f"))).isEqualTo(255L);
    }

    @Test
    public void testBar() {
        Assertions.assertThat((Comparable)ColorFunctions.bar((double)0.6, (long)5L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f0f")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;201m\u2588\u001b[38;5;165m\u2588\u001b[38;5;129m\u2588\u001b[0m  "));
        Assertions.assertThat((Comparable)ColorFunctions.bar((double)1.0, (long)10L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;196m\u2588\u001b[38;5;202m\u2588\u001b[38;5;208m\u2588\u001b[38;5;214m\u2588\u001b[38;5;226m\u2588\u001b[38;5;226m\u2588\u001b[38;5;154m\u2588\u001b[38;5;118m\u2588\u001b[38;5;82m\u2588\u001b[38;5;46m\u2588\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.bar((double)0.6, (long)5L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f0f")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;201m\u2588\u001b[38;5;165m\u2588\u001b[38;5;129m\u2588\u001b[0m  "));
    }

    @Test
    public void testRenderBoolean() {
        Assertions.assertThat((Comparable)ColorFunctions.render((boolean)true)).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;2m\u2713\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((boolean)false)).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;1m\u2717\u001b[0m"));
    }

    @Test
    public void testRenderString() {
        Assertions.assertThat((Comparable)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;1mhello\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;196mhello\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;46mhello\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((Slice)Slices.utf8Slice((String)"hello"), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;21mhello\u001b[0m"));
    }

    @Test
    public void testRenderLong() {
        Assertions.assertThat((Comparable)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;1m1234\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;196m1234\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;46m1234\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;21m1234\u001b[0m"));
    }

    @Test
    public void testRenderDouble() {
        Assertions.assertThat((Comparable)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;1m1234.5678\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((double)1234.5677490234375, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"red")))).isEqualTo((Object)Slices.utf8Slice((String)String.format("\u001b[38;5;1m%s\u001b[0m", 1234.5677490234375)));
        Assertions.assertThat((Comparable)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#f00")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;196m1234.5678\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#0f0")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;46m1234.5678\u001b[0m"));
        Assertions.assertThat((Comparable)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#00f")))).isEqualTo((Object)Slices.utf8Slice((String)"\u001b[38;5;21m1234.5678\u001b[0m"));
    }

    @Test
    public void testInterpolate() {
        Assertions.assertThat((long)ColorFunctions.color((double)0.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0L);
        Assertions.assertThat((long)ColorFunctions.color((double)0.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0L);
        Assertions.assertThat((long)ColorFunctions.color((double)128.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0x808080L);
        Assertions.assertThat((long)ColorFunctions.color((double)255.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0xFFFFFFL);
        Assertions.assertThat((long)ColorFunctions.color((double)-1.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L))).isEqualTo(0xFF0000L);
        Assertions.assertThat((long)ColorFunctions.color((double)47.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L))).isEqualTo(0xFF8000L);
        Assertions.assertThat((long)ColorFunctions.color((double)142.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L))).isEqualTo(0xFFFF00L);
        Assertions.assertThat((long)ColorFunctions.color((double)-42.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0L);
        Assertions.assertThat((long)ColorFunctions.color((double)0.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0L);
        Assertions.assertThat((long)ColorFunctions.color((double)0.5, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0x808080L);
        Assertions.assertThat((long)ColorFunctions.color((double)1.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0xFFFFFFL);
        Assertions.assertThat((long)ColorFunctions.color((double)42.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0xFFFFFFL);
        Assertions.assertThat((long)ColorFunctions.color((double)1.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0xFFFFFFL);
        Assertions.assertThat((long)ColorFunctions.color((double)-0.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0L);
        Assertions.assertThat((long)ColorFunctions.color((double)0.0, (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#000")), (long)ColorFunctions.color((Slice)Slices.utf8Slice((String)"#fff")))).isEqualTo(0L);
    }

    @Test
    public void testIndeterminate() {
        try (QueryAssertions assertions = new QueryAssertions();){
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.operator(OperatorType.INDETERMINATE, "color(null)")))).isEqualTo(true);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.operator(OperatorType.INDETERMINATE, "color('black')")))).isEqualTo(false);
        }
    }
}

