/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDataSizeFunctions {
    private static final DecimalType DECIMAL = DecimalType.createDecimalType((int)38, (int)0);
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testParseDataSize() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'0B'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'1B'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'1.2B'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'1.9B'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'2.2kB'")))).isEqualTo(SqlDecimal.decimal((String)"2252", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'2.23kB'")))).isEqualTo(SqlDecimal.decimal((String)"2283", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'2.234kB'")))).isEqualTo(SqlDecimal.decimal((String)"2287", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'3MB'")))).isEqualTo(SqlDecimal.decimal((String)"3145728", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'4GB'")))).isEqualTo(SqlDecimal.decimal((String)"4294967296", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'4TB'")))).isEqualTo(SqlDecimal.decimal((String)"4398046511104", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'5PB'")))).isEqualTo(SqlDecimal.decimal((String)"5629499534213120", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'6EB'")))).isEqualTo(SqlDecimal.decimal((String)"6917529027641081856", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'7ZB'")))).isEqualTo(SqlDecimal.decimal((String)"8264141345021879123968", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'8YB'")))).isEqualTo(SqlDecimal.decimal((String)"9671406556917033397649408", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'6917529027641081856EB'")))).isEqualTo(SqlDecimal.decimal((String)"7975367974709495237422842361682067456", (DecimalType)DECIMAL));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_data_size", "'69175290276410818560EB'")))).isEqualTo(SqlDecimal.decimal((String)"79753679747094952374228423616820674560", (DecimalType)DECIMAL));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "''")::evaluate).hasMessage("Invalid data size: ''");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "'0'")::evaluate).hasMessage("Invalid data size: '0'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "'10KB'")::evaluate).hasMessage("Invalid data size: '10KB'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "'KB'")::evaluate).hasMessage("Invalid data size: 'KB'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "'-1B'")::evaluate).hasMessage("Invalid data size: '-1B'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "'12345K'")::evaluate).hasMessage("Invalid data size: '12345K'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "'A12345B'")::evaluate).hasMessage("Invalid data size: 'A12345B'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_data_size", "'99999999999999YB'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Value out of range: '99999999999999YB' ('120892581961461708544797985370825293824B')");
    }
}

