/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.io.Resources;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.AbstractTestRegexpFunctions;
import io.trino.operator.scalar.JoniRegexpCasts;
import io.trino.operator.scalar.JoniRegexpFunctions;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.analyzer.RegexLibrary;
import io.trino.type.JoniRegexp;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJoniRegexpFunctions
extends AbstractTestRegexpFunctions {
    public TestJoniRegexpFunctions() {
        super(RegexLibrary.JONI);
    }

    @Test
    public void testSearchInterruptible() throws IOException, InterruptedException {
        String source = Resources.toString((URL)Resources.getResource((String)"regularExpressionExtraLongSource.txt"), (Charset)StandardCharsets.UTF_8);
        String pattern = "\\((.*,)+(.*\\))";
        TestJoniRegexpFunctions.testJoniRegexpFunctionsInterruptible(() -> JoniRegexpFunctions.regexpReplace((Slice)Slices.utf8Slice((String)source), (JoniRegexp)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)pattern))));
    }

    private static void testJoniRegexpFunctionsInterruptible(Runnable joniRegexpRunnable) throws InterruptedException {
        AtomicReference trinoException = new AtomicReference();
        Thread searchChildThread = new Thread(() -> {
            try {
                joniRegexpRunnable.run();
            }
            catch (TrinoException e) {
                trinoException.compareAndSet(null, e);
            }
        });
        searchChildThread.start();
        searchChildThread.join(1000L);
        searchChildThread.interrupt();
        searchChildThread.join();
        Assertions.assertThat((Throwable)((TrinoException)((Object)trinoException.get()))).isNotNull();
        Assertions.assertThat((Object)((TrinoException)((Object)trinoException.get())).getErrorCode()).isEqualTo((Object)StandardErrorCode.GENERIC_USER_ERROR.toErrorCode());
    }
}

