/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExtract {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void tearDown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1234+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12345+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123456+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '12'");
    }

    @Test
    public void testMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1234+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12345+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123456+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '34'");
    }

    @Test
    public void testSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1234+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12345+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123456+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '56'");
    }

    @Test
    public void testMillisecond() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MILLISECOND FROM TIME '12:34:56+08:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:12: Invalid EXTRACT field: MILLISECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56+08:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1+08:35')")))).matches("BIGINT '100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12+08:35')")))).matches("BIGINT '120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1234+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12345+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123456+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '123'");
    }

    @Test
    public void testTimezoneHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567890-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678901-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789012-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234567-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345678-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456789-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234567890-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345678901-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456789012-08:35')")))).matches("BIGINT '-8'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567890-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678901-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789012-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234567-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345678-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456789-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.1234567890-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.12345678901-00:35')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIME '12:34:56.123456789012-00:35')")))).matches("BIGINT '0'");
    }

    @Test
    public void testTimezoneMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234567+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345678+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456789+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234567890+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345678901+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456789012+08:35')")))).matches("BIGINT '35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567890-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678901-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789012-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234567-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345678-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456789-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234567890-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345678901-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456789012-08:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567890-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678901-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789012-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234567-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345678-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456789-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.1234567890-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.12345678901-00:35')")))).matches("BIGINT '-35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIME '12:34:56.123456789012-00:35')")))).matches("BIGINT '-35'");
    }

    @Test
    public void testUnsupported() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1234-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12345-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123456-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1234567-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12345678-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123456789-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1234567890-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12345678901-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123456789012-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1234-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12345-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123456-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1234567-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12345678-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123456789-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1234567890-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12345678901-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123456789012-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1234-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12345-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123456-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1234567-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12345678-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123456789-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1234567890-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12345678901-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123456789012-00:35')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }
}

