/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.collect.ImmutableMap;
import io.trino.operator.window.matcher.MatchAssert;
import io.trino.sql.planner.rowpattern.Patterns;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPatternMatchingMachine {
    private static final Map<IrLabel, Integer> LABEL_MAPPING = ImmutableMap.of((Object)new IrLabel("A"), (Object)0, (Object)new IrLabel("B"), (Object)1, (Object)new IrLabel("C"), (Object)2, (Object)new IrLabel("D"), (Object)3, (Object)new IrLabel("E"), (Object)4);

    @Test
    public void testCaptures() {
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.excluded((IrRowPattern)Patterns.label("A")), Patterns.label("B")}), "ABCD")))).hasCaptures(new int[]{0, 1});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.excluded(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")})), "ABCD")))).hasCaptures(new int[]{0, 2});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.excluded((IrRowPattern)Patterns.label("B"))}), "ABCD")))).hasCaptures(new int[]{1, 2});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.starQuantified(Patterns.excluded((IrRowPattern)Patterns.label("B")), true)}), "ABBBCD")))).hasCaptures(new int[]{1, 2, 2, 3, 3, 4});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.excluded(Patterns.starQuantified((IrRowPattern)Patterns.label("B"), true))}), "ABBBCD")))).hasCaptures(new int[]{1, 4});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.starQuantified(Patterns.excluded((IrRowPattern)Patterns.label("B")), true), Patterns.label("C"), Patterns.excluded(Patterns.starQuantified((IrRowPattern)Patterns.label("D"), true))}), "ABBCDDDE")))).hasCaptures(new int[]{1, 2, 2, 3, 4, 7});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.starQuantified(Patterns.concatenation(new IrRowPattern[]{Patterns.excluded(Patterns.concatenation(new IrRowPattern[]{Patterns.label("B"), Patterns.label("C")})), Patterns.label("D"), Patterns.excluded((IrRowPattern)Patterns.label("E"))}), true)}), "ABCDEBCDEBCDE")))).hasCaptures(new int[]{1, 3, 4, 5, 5, 7, 8, 9, 9, 11, 12, 13});
    }

    @Test
    public void testMatchWithoutCaptures() {
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), "ABCD")))).hasCaptures(new int[0]);
    }

    @Test
    public void testEmptyMatch() {
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.empty(), "ABCD")))).hasCaptures(new int[0]).hasLabels(new char[0]);
    }

    @Test
    public void testNoMatch() {
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match((IrRowPattern)Patterns.label("A"), "B")))).isNoMatch();
    }

    @Test
    public void testLabels() {
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), "ABCD")))).hasLabels(new char[]{'A', 'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.starQuantified((IrRowPattern)Patterns.label("A"), true), Patterns.label("B")}), "AABCD")))).hasLabels(new char[]{'A', 'A', 'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.starQuantified((IrRowPattern)Patterns.label("A"), true), Patterns.label("B")}), "BCD")))).hasLabels(new char[]{'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.start(), Patterns.label("A"), Patterns.label("B")}), "ABCD")))).hasLabels(new char[]{'A', 'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.end()}), "AB")))).hasLabels(new char[]{'A', 'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.excluded((IrRowPattern)Patterns.label("A")), Patterns.label("B")}), "ABCD")))).hasLabels(new char[]{'A', 'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.alternation(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), Patterns.concatenation(new IrRowPattern[]{Patterns.label("B"), Patterns.label("C")})), "ABCD")))).hasLabels(new char[]{'A', 'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}), "ABCD")))).hasLabels(new char[]{'A', 'B', 'C'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("B"), true)}), "ABCD")))).hasLabels(new char[]{'A', 'B'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("B"), false)}), "ABCD")))).hasLabels(new char[]{'A'});
    }

    @Test
    public void testLongMatch() {
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.starQuantified((IrRowPattern)Patterns.label("A"), true), "AAAAAAAAAA")))).hasLabels(new char[]{'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A'});
        ((MatchAssert)((Object)Assertions.assertThat(TestPatternMatchingMachine.match(Patterns.concatenation(Patterns.start(), Patterns.plusQuantified(Patterns.plusQuantified((IrRowPattern)Patterns.label("A"), true), true), Patterns.end()), "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB")))).isNoMatch();
    }

    private static AssertProvider<MatchAssert> match(IrRowPattern pattern, String input) {
        return MatchAssert.match(pattern, input, LABEL_MAPPING);
    }
}

