/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.server.protocol.spooling.SpooledBlock;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.protocol.SpooledLocation;
import io.trino.spi.type.BigintType;
import java.net.URI;
import java.util.Map;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class TestSpooledBlock {
    TestSpooledBlock() {
    }

    @Test
    public void testSerializationRoundTrip() {
        this.verifySerialization((SpooledLocation)SpooledLocation.directLocation((URI)URI.create("https://example.com/presigned"), (Map)ImmutableMap.of((Object)"X-Header", (Object)ImmutableList.of((Object)"value1", (Object)"value2"))));
        this.verifySerialization((SpooledLocation)SpooledLocation.coordinatorLocation((Slice)Slices.utf8Slice((String)"identifier"), (Map)ImmutableMap.of((Object)"X-Header", (Object)ImmutableList.of((Object)"value1", (Object)"value2"))));
    }

    public void verifySerialization(SpooledLocation location) {
        this.verifySerializationRoundTrip(location);
        this.verifySerializationRoundTripWithNonEmptyPage(location);
        this.verifyThrowsErrorOnNonNullPositions(location);
        this.verifyThrowsErrorOnMultiplePositions(location);
    }

    public void verifySerializationRoundTrip(SpooledLocation location) {
        SpooledBlock metadata = new SpooledBlock(location, TestSpooledBlock.createDataAttributes(10L, 1200));
        Page page = new Page(new Block[]{metadata.serialize()});
        SpooledBlock retrieved = SpooledBlock.deserialize((Page)page);
        AssertionsForClassTypes.assertThat((Object)metadata).isEqualTo((Object)retrieved);
    }

    private void verifySerializationRoundTripWithNonEmptyPage(SpooledLocation location) {
        SpooledBlock metadata = new SpooledBlock(location, TestSpooledBlock.createDataAttributes(10L, 1100));
        Page page = new Page(new Block[]{TestSpooledBlock.blockWithPositions(1, true), metadata.serialize()});
        SpooledBlock retrieved = SpooledBlock.deserialize((Page)page);
        AssertionsForClassTypes.assertThat((Object)metadata).isEqualTo((Object)retrieved);
    }

    private void verifyThrowsErrorOnNonNullPositions(SpooledLocation location) {
        SpooledBlock metadata = new SpooledBlock(location, TestSpooledBlock.createDataAttributes(20L, 1200));
        AssertionsForClassTypes.assertThatThrownBy(() -> SpooledBlock.deserialize((Page)new Page(new Block[]{TestSpooledBlock.blockWithPositions(1, false), metadata.serialize()}))).hasMessage("Spooling metadata block must have all but last channels null");
    }

    private void verifyThrowsErrorOnMultiplePositions(SpooledLocation location) {
        SpooledBlock metadata = new SpooledBlock(location, TestSpooledBlock.createDataAttributes(30L, 1300));
        RowBlockBuilder rowBlockBuilder = SpooledBlock.SPOOLING_METADATA_TYPE.createBlockBuilder(null, 2);
        metadata.serialize(rowBlockBuilder);
        metadata.serialize(rowBlockBuilder);
        AssertionsForClassTypes.assertThatThrownBy(() -> SpooledBlock.deserialize((Page)new Page(new Block[]{TestSpooledBlock.blockWithPositions(2, false), rowBlockBuilder.build()}))).hasMessage("Spooling metadata block must have a single position");
    }

    public static Block blockWithPositions(int count, boolean isNull) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(count);
        for (int i = 0; i < count; ++i) {
            if (isNull) {
                blockBuilder.appendNull();
                continue;
            }
            BigintType.BIGINT.writeLong(blockBuilder, 0L);
        }
        return blockBuilder.build();
    }

    private static DataAttributes createDataAttributes(long rows, int segmentSize) {
        return DataAttributes.builder().set(DataAttribute.ROWS_COUNT, (Object)rows).set(DataAttribute.SEGMENT_SIZE, (Object)segmentSize).build();
    }
}

