/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUserMapping {
    private final File testFile = new File(Resources.getResource((String)"user-mapping.json").toURI());

    @Test
    public void testStaticFactory() throws Exception {
        UserMapping defaultUserMapping = UserMapping.createUserMapping(Optional.empty(), Optional.empty());
        Assertions.assertThat((String)defaultUserMapping.mapUser("test@example.com")).isEqualTo("test@example.com");
        UserMapping singlePatternUserMapping = UserMapping.createUserMapping(Optional.of("(.*?)@.*"), Optional.empty());
        Assertions.assertThat((String)singlePatternUserMapping.mapUser("test@example.com")).isEqualTo("test");
        UserMapping fileUserMapping = UserMapping.createUserMapping(Optional.empty(), Optional.of(this.testFile));
        Assertions.assertThat((String)fileUserMapping.mapUser("test@example.com")).isEqualTo("test_file");
        Assertions.assertThat((String)fileUserMapping.mapUser("user")).isEqualTo("user");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fileUserMapping.mapUser("test")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UserMapping.createUserMapping(Optional.of("(.*?)@.*"), Optional.of(this.testFile))).isInstanceOf(IllegalArgumentException.class)).hasMessage("user mapping pattern and file can not both be set");
    }

    @Test
    public void testSimplePatternRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*")));
        Assertions.assertThat((String)userMapping.mapUser("test@example.com")).isEqualTo("test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("no at sign")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("@no user string")).isInstanceOf(UserMappingException.class)).hasMessage("Principal matched, but mapped user is empty");
    }

    @Test
    public void testReplacePatternRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "$1 ^ $1", true, UserMapping.Case.KEEP)));
        Assertions.assertThat((String)userMapping.mapUser("test@example.com")).isEqualTo("test ^ test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("no at sign")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
        UserMapping emptyMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "  ", true, UserMapping.Case.KEEP)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> emptyMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal matched, but mapped user is empty");
    }

    @Test
    public void testNotAllowedRule() {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "$1", false, UserMapping.Case.KEEP)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        UserMapping emptyMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "", false, UserMapping.Case.KEEP)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> emptyMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
    }

    @Test
    public void testMultipleRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("test@example.com", "", false, UserMapping.Case.KEEP), (Object)new UserMapping.Rule("(.*?)@example.com")));
        Assertions.assertThat((String)userMapping.mapUser("apple@example.com")).isEqualTo("apple");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("apple@other.example.com")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
    }

    @Test
    public void testLowercaseUsernameRule() throws UserMappingException {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*)@EXAMPLE\\.COM", "$1", true, UserMapping.Case.LOWER)));
        Assertions.assertThat((String)userMapping.mapUser("TEST@EXAMPLE.COM")).isEqualTo("test");
    }

    @Test
    public void testUppercaseUsernameRule() throws UserMappingException {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*)@example\\.com", "$1", true, UserMapping.Case.UPPER)));
        Assertions.assertThat((String)userMapping.mapUser("test@example.com")).isEqualTo("TEST");
    }

    @Test
    public void testDocsExample() throws Exception {
        File docExample = new File("../../docs/src/main/sphinx/security/user-mapping.json");
        UserMapping userMapping = UserMapping.createUserMapping(Optional.empty(), Optional.of(docExample));
        Assertions.assertThat((String)userMapping.mapUser("apple@example.com")).isEqualTo("apple");
        Assertions.assertThat((String)userMapping.mapUser("apple@uk.example.com")).isEqualTo("apple_uk");
        Assertions.assertThat((String)userMapping.mapUser("apple@de.example.com")).isEqualTo("apple_de");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("apple@unknown.com")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        Assertions.assertThat((String)userMapping.mapUser("test@uppercase.com")).isEqualTo("TEST");
    }
}

