/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.WorkProcessor;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProcessorMetrics;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.ShortArrayBlock;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@Warmup(iterations=15, time=1)
@Measurement(iterations=15, time=1)
public class BenchmarkColumnarFilter {
    private static final Random RANDOM = new Random(5376453765L);
    private static final long CONSTANT = 8456L;
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private PageProcessor compiledProcessor;
    private final List<Page> inputPages = new ArrayList<Page>();
    @Param(value={"true", "false"})
    public boolean columnarEvaluationEnabled;
    @Param(value={"0", "10"})
    public int nullsPercentage;
    @Param(value={"BETWEEN", "LESS_THAN", "IS_NULL", "IS_NOT_NULL"})
    public FilterProvider filterProvider;
    public String dataType = "integer";

    @Setup
    public void setup() {
        for (int pageCount = 0; pageCount < 20; ++pageCount) {
            String block = switch (this.dataType) {
                case "bigint" -> BenchmarkColumnarFilter.createLongsBlock(8192, this.nullsPercentage);
                case "integer" -> BenchmarkColumnarFilter.createIntsBlock(8192, this.nullsPercentage);
                case "smallint" -> BenchmarkColumnarFilter.createShortsBlock(8192, this.nullsPercentage);
                default -> throw new UnsupportedOperationException();
            };
            this.inputPages.add(new Page(block.getPositionCount(), new Block[]{block}));
        }
        BigintType type = switch (this.dataType) {
            case "bigint" -> BigintType.BIGINT;
            case "integer" -> IntegerType.INTEGER;
            case "smallint" -> SmallintType.SMALLINT;
            default -> throw new UnsupportedOperationException();
        };
        ExpressionCompiler expressionCompiler = FUNCTION_RESOLUTION.getExpressionCompiler();
        this.compiledProcessor = (PageProcessor)expressionCompiler.compilePageProcessor(this.columnarEvaluationEnabled, Optional.of(this.filterProvider.getExpression((Type)type)), Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)type)), Optional.empty(), OptionalInt.empty()).apply(DynamicFilter.EMPTY);
    }

    @Benchmark
    public long evaluateFilter() {
        LocalMemoryContext context = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        long outputRows = 0L;
        for (Page inputPage : this.inputPages) {
            WorkProcessor workProcessor = this.compiledProcessor.createWorkProcessor(null, new DriverYieldSignal(), context, new PageProcessorMetrics(), inputPage);
            if (!workProcessor.process() || workProcessor.isFinished()) continue;
            outputRows += (long)((Page)workProcessor.getResult()).getPositionCount();
        }
        return outputRows;
    }

    public static void runAllCombinations() {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean columnarEvaluationEnabled = (Boolean)unmodifiableIterator.next();
            for (FilterProvider filterProvider : FilterProvider.values()) {
                for (String dataType : ImmutableList.of((Object)"bigint", (Object)"integer", (Object)"smallint")) {
                    UnmodifiableIterator unmodifiableIterator2 = ImmutableList.of((Object)0, (Object)10).iterator();
                    while (unmodifiableIterator2.hasNext()) {
                        int nullsPercentage = (Integer)unmodifiableIterator2.next();
                        BenchmarkColumnarFilter benchmark = new BenchmarkColumnarFilter();
                        benchmark.filterProvider = filterProvider;
                        benchmark.dataType = dataType;
                        benchmark.columnarEvaluationEnabled = columnarEvaluationEnabled;
                        benchmark.nullsPercentage = nullsPercentage;
                        benchmark.setup();
                        benchmark.evaluateFilter();
                    }
                }
            }
        }
    }

    private static Block createShortsBlock(int positionsCount, int nullsPercentage) {
        short[] values = new short[positionsCount];
        boolean[] isNull = new boolean[positionsCount];
        for (int i = 0; i < positionsCount; ++i) {
            if (RANDOM.nextInt(100) < nullsPercentage) {
                isNull[i] = true;
                continue;
            }
            values[i] = (short)RANDOM.nextInt(Math.toIntExact(8446L), Math.toIntExact(8466L));
        }
        return new ShortArrayBlock(positionsCount, Optional.of(isNull), values);
    }

    private static Block createIntsBlock(int positionsCount, int nullsPercentage) {
        int[] values = new int[positionsCount];
        boolean[] isNull = new boolean[positionsCount];
        for (int i = 0; i < positionsCount; ++i) {
            if (RANDOM.nextInt(100) < nullsPercentage) {
                isNull[i] = true;
                continue;
            }
            values[i] = RANDOM.nextInt(Math.toIntExact(8446L), Math.toIntExact(8466L));
        }
        return new IntArrayBlock(positionsCount, Optional.of(isNull), values);
    }

    private static Block createLongsBlock(int positionsCount, int nullsPercentage) {
        long[] values = new long[positionsCount];
        boolean[] isNull = new boolean[positionsCount];
        for (int i = 0; i < positionsCount; ++i) {
            if (RANDOM.nextInt(100) < nullsPercentage) {
                isNull[i] = true;
                continue;
            }
            values[i] = RANDOM.nextInt(Math.toIntExact(8446L), Math.toIntExact(8466L));
        }
        return new LongArrayBlock(positionsCount, Optional.of(isNull), values);
    }

    public static void main(String[] args) throws Throwable {
        Benchmarks.benchmark(BenchmarkColumnarFilter.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgsAppend(new String[]{"-Xmx4g", "-Xms4g"})).run();
    }

    static {
        try {
            BenchmarkColumnarFilter.runAllCombinations();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static enum FilterProvider {
        BETWEEN{

            @Override
            RowExpression getExpression(Type type) {
                return new SpecialForm(SpecialForm.Form.BETWEEN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)type), (Object)Expressions.constant((Object)8451L, (Type)type), (Object)Expressions.constant((Object)8461L, (Type)type)), (List)ImmutableList.of((Object)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))));
            }
        }
        ,
        LESS_THAN{

            @Override
            RowExpression getExpression(Type type) {
                return Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)8456L, (Type)type), Expressions.field((int)0, (Type)type)});
            }
        }
        ,
        IS_NULL{

            @Override
            RowExpression getExpression(Type type) {
                return new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)type)), (List)ImmutableList.of());
            }
        }
        ,
        IS_NOT_NULL{

            @Override
            RowExpression getExpression(Type type) {
                return Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveFunction("$not", TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})), (RowExpression[])new RowExpression[]{new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)type)), (List)ImmutableList.of())});
            }
        };


        abstract RowExpression getExpression(Type var1);
    }
}

