/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateArray;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class TestEvaluateArray {
    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Array((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))))).isPresent()).satisfies(new ThrowingConsumer[]{result -> {
            Constant constant = (Constant)result.get();
            Assertions.assertThat((long)BigintType.BIGINT.getLong((Block)constant.value(), 0)).isEqualTo(1L);
        }});
        Assertions.assertThat(this.optimize((Expression)new Array((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Reference((Type)BigintType.BIGINT, "x"))))).isEmpty();
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateArray().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

