/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateBind;
import io.trino.sql.planner.Symbol;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateBind {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Bind((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L)), new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isEqualTo(Optional.of(new Lambda((List)ImmutableList.of(), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))));
        Assertions.assertThat(this.optimize((Expression)new Bind((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Reference((Type)BigintType.BIGINT, "x")), new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b")), (Expression)new Array((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))))))).isEqualTo(Optional.of(new Bind((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x")), new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "b")), (Expression)new Array((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Reference((Type)BigintType.BIGINT, "b")))))));
        Assertions.assertThat(this.optimize((Expression)new Bind((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Reference((Type)BigintType.BIGINT, "x")), new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a"), (Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c")), (Expression)new Array((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"), (Object)new Reference((Type)BigintType.BIGINT, "c"))))))).isEqualTo(Optional.of(new Bind((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x")), new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "b"), (Object)new Symbol((Type)BigintType.BIGINT, "c")), (Expression)new Array((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Reference((Type)BigintType.BIGINT, "b"), (Object)new Reference((Type)BigintType.BIGINT, "c")))))));
        Assertions.assertThat(this.optimize((Expression)new Bind((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "x")), new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "a")), (Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateBind().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

