/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantCoalesceArguments;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantCoalesceArguments {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution(InMemoryTransactionManager.createTestTransactionManager(), TestingPlannerContext.PLANNER_CONTEXT);
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", (List<TypeSignatureProvider>)ImmutableList.of());

    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null), new Expression[0]))).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, null)));
        Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), new Expression[0]))).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, (Object)1L)));
        Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "a"), new Expression[]{new Reference((Type)BigintType.BIGINT, "a")}))).isEqualTo(Optional.of(new Reference((Type)BigintType.BIGINT, "a")));
        Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"), new Expression[]{new Constant((Type)BigintType.BIGINT, (Object)1L), new Reference((Type)BigintType.BIGINT, "c"), new Reference((Type)BigintType.BIGINT, "d")}))).isEqualTo(Optional.of(new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"), new Expression[]{new Constant((Type)BigintType.BIGINT, (Object)1L)})));
        Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"), new Expression[]{new Reference((Type)BigintType.BIGINT, "a"), new Reference((Type)BigintType.BIGINT, "c")}))).isEqualTo(Optional.of(new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"), new Expression[]{new Reference((Type)BigintType.BIGINT, "c")})));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Call(RANDOM, (List)ImmutableList.of()), new Expression[0]))).describedAs("non-deterministic arguments", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Reference((Type)DoubleType.DOUBLE, "a"), (Expression)new Reference((Type)DoubleType.DOUBLE, "b"), new Expression[]{new Call(RANDOM, (List)ImmutableList.of()), new Call(RANDOM, (List)ImmutableList.of()), new Reference((Type)DoubleType.DOUBLE, "a")}))).describedAs("non-deterministic and deterministic arguments", new Object[0])).isEqualTo(Optional.of(new Coalesce((Expression)new Reference((Type)DoubleType.DOUBLE, "a"), (Expression)new Reference((Type)DoubleType.DOUBLE, "b"), new Expression[]{new Call(RANDOM, (List)ImmutableList.of()), new Call(RANDOM, (List)ImmutableList.of())})));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new RemoveRedundantCoalesceArguments().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

