/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.SimplifyRedundantCast;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyRedundantCast {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Type)BigintType.BIGINT))).isEqualTo(Optional.of(new Reference((Type)BigintType.BIGINT, "a")));
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Type)BigintType.BIGINT))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SimplifyRedundantCast().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

