/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.SimplifyStackedArithmeticNegation;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyStackedArithmeticNegation {
    @Test
    void test() {
        ResolvedFunction negation = new TestingFunctionResolution().resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT));
        Assertions.assertThat(this.optimize((Expression)new Call(negation, (List)ImmutableList.of((Object)new Call(negation, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))))))).isEqualTo(Optional.of(new Reference((Type)BigintType.BIGINT, "a")));
        Assertions.assertThat(this.optimize((Expression)new Call(negation, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SimplifyStackedArithmeticNegation().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

