/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestRecursiveCte
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction FAIL = FUNCTIONS.resolveFunction("fail", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR}));
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    @Override
    protected PlanTester createPlanTester() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setSystemProperty("max_recursion_depth", "1");
        return PlanTester.create((Session)sessionBuilder.build());
    }

    @Test
    public void testRecursiveQuery() {
        String sql = "WITH RECURSIVE t(n) AS (                SELECT 1                UNION ALL                SELECT n + 2 FROM t WHERE n < 6                )                SELECT * from t";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), PlanMatchPattern.values(new String[0])))), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "expr"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "expr"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), PlanMatchPattern.values(new String[0])))))))), PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "count"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Expression)new Cast((Expression)new Call(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Recursion depth limit exceeded (1). Use 'max_recursion_depth' session property to modify the limit.")))), (Type)BooleanType.BOOLEAN), (Expression)Booleans.TRUE), PlanMatchPattern.window(windowBuilder -> windowBuilder.addFunction("count", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "expr"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "expr"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "expr_0"))), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "expr"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "expr"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), PlanMatchPattern.values(new String[0])))))))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

