/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionAndValuePointersMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MeasureMatcher
implements RvalueMatcher {
    private final ExpressionAndValuePointers expression;
    private final Map<IrLabel, Set<IrLabel>> subsets;
    private final Type type;

    public MeasureMatcher(ExpressionAndValuePointers expression, Map<IrLabel, Set<IrLabel>> subsets, Type type) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.subsets = Objects.requireNonNull(subsets, "subsets is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Symbol> result = Optional.empty();
        if (!(node instanceof PatternRecognitionNode)) {
            return result;
        }
        PatternRecognitionNode patternRecognitionNode = (PatternRecognitionNode)node;
        PatternRecognitionNode.Measure expectedMeasure = new PatternRecognitionNode.Measure(this.expression, this.type);
        for (Map.Entry assignment : patternRecognitionNode.getMeasures().entrySet()) {
            PatternRecognitionNode.Measure actualMeasure = (PatternRecognitionNode.Measure)assignment.getValue();
            if (!MeasureMatcher.measuresEquivalent(actualMeasure, expectedMeasure, symbolAliases)) continue;
            Preconditions.checkState((boolean)result.isEmpty(), (String)"Ambiguous measures in %s", (Object)patternRecognitionNode);
            result = Optional.of((Symbol)assignment.getKey());
        }
        return result;
    }

    private static boolean measuresEquivalent(PatternRecognitionNode.Measure actual, PatternRecognitionNode.Measure expected, SymbolAliases symbolAliases) {
        if (!actual.getType().equals((Object)expected.getType())) {
            return false;
        }
        return ExpressionAndValuePointersMatcher.matches(expected.getExpressionAndValuePointers(), actual.getExpressionAndValuePointers(), symbolAliases);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).add("subsets", this.subsets).add("type", (Object)this.type).toString();
    }
}

