/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AliasMatcher;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionAndValuePointersMatcher;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.MeasureMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.WindowFrameMatcher;
import io.trino.sql.planner.assertions.WindowFunction;
import io.trino.sql.planner.assertions.WindowFunctionMatcher;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.type.UnknownType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PatternRecognitionMatcher
implements Matcher {
    private final Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification;
    private final Optional<WindowNode.Frame> frame;
    private final RowsPerMatch rowsPerMatch;
    private final Set<IrLabel> skipToLabels;
    private final SkipToPosition skipToPosition;
    private final boolean initial;
    private final IrRowPattern pattern;
    private final Map<IrLabel, ExpressionAndValuePointers> variableDefinitions;

    private PatternRecognitionMatcher(Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification, Optional<WindowNode.Frame> frame, RowsPerMatch rowsPerMatch, Set<IrLabel> skipToLabels, SkipToPosition skipToPosition, boolean initial, IrRowPattern pattern, Map<IrLabel, ExpressionAndValuePointers> variableDefinitions) {
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
        this.rowsPerMatch = Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        this.skipToLabels = ImmutableSet.copyOf(skipToLabels);
        this.skipToPosition = Objects.requireNonNull(skipToPosition, "skipToPosition is null");
        this.initial = initial;
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.variableDefinitions = Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof PatternRecognitionNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        PatternRecognitionNode patternRecognitionNode = (PatternRecognitionNode)node;
        boolean specificationMatches = this.specification.map(expected -> ((DataOrganizationSpecification)expected.getExpectedValue(symbolAliases)).equals((Object)patternRecognitionNode.getSpecification())).orElse(true);
        if (!specificationMatches) {
            return MatchResult.NO_MATCH;
        }
        if (this.frame.isPresent()) {
            if (patternRecognitionNode.getCommonBaseFrame().isEmpty()) {
                return MatchResult.NO_MATCH;
            }
            if (!WindowFrameMatcher.matches(this.frame.get(), (WindowNode.Frame)patternRecognitionNode.getCommonBaseFrame().get(), symbolAliases)) {
                return MatchResult.NO_MATCH;
            }
        }
        if (this.rowsPerMatch != patternRecognitionNode.getRowsPerMatch()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.skipToLabels.equals(patternRecognitionNode.getSkipToLabels())) {
            return MatchResult.NO_MATCH;
        }
        if (this.skipToPosition != patternRecognitionNode.getSkipToPosition()) {
            return MatchResult.NO_MATCH;
        }
        if (this.initial != patternRecognitionNode.isInitial()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.pattern.equals(patternRecognitionNode.getPattern())) {
            return MatchResult.NO_MATCH;
        }
        if (this.variableDefinitions.size() != patternRecognitionNode.getVariableDefinitions().size()) {
            return MatchResult.NO_MATCH;
        }
        for (Map.Entry<IrLabel, ExpressionAndValuePointers> entry : this.variableDefinitions.entrySet()) {
            IrLabel name = entry.getKey();
            ExpressionAndValuePointers actual = (ExpressionAndValuePointers)patternRecognitionNode.getVariableDefinitions().get(name);
            if (actual == null) {
                return MatchResult.NO_MATCH;
            }
            if (ExpressionAndValuePointersMatcher.matches(entry.getValue(), actual, symbolAliases)) continue;
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("specification", this.specification.orElse(null)).add("frame", this.frame.orElse(null)).add("rowsPerMatch", (Object)this.rowsPerMatch).add("skipToLabels", this.skipToLabels).add("skipToPosition", (Object)this.skipToPosition).add("initial", this.initial).add("pattern", (Object)this.pattern).add("variableDefinitions", this.variableDefinitions).toString();
    }

    record TypedExpressionAndPointers(ExpressionAndValuePointers expression, Type type) {
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification = Optional.empty();
        private final List<AliasMatcher> windowFunctionMatchers = new LinkedList<AliasMatcher>();
        private final Map<String, TypedExpressionAndPointers> measures = new HashMap<String, TypedExpressionAndPointers>();
        private Optional<WindowNode.Frame> frame = Optional.empty();
        private RowsPerMatch rowsPerMatch = RowsPerMatch.ONE;
        private Set<IrLabel> skipToLabels = ImmutableSet.of();
        private SkipToPosition skipToPosition = SkipToPosition.PAST_LAST;
        private boolean initial = true;
        private IrRowPattern pattern;
        private final Map<IrLabel, Set<IrLabel>> subsets = new HashMap<IrLabel, Set<IrLabel>>();
        private final Map<IrLabel, ExpressionAndValuePointers> variableDefinitions = new HashMap<IrLabel, ExpressionAndValuePointers>();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        @CanIgnoreReturnValue
        public Builder specification(ExpectedValueProvider<DataOrganizationSpecification> specification) {
            this.specification = Optional.of(specification);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFunction(String outputAlias, ExpectedValueProvider<WindowFunction> functionCall) {
            this.windowFunctionMatchers.add(new AliasMatcher(Optional.of(outputAlias), new WindowFunctionMatcher(functionCall)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addMeasure(String outputAlias, Expression expression, Type type) {
            this.measures.put(outputAlias, new TypedExpressionAndPointers(new ExpressionAndValuePointers(expression, (List)ImmutableList.of()), type));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addMeasure(String outputAlias, Expression expression, Map<String, ValuePointer> pointers, Type type) {
            List<ExpressionAndValuePointers.Assignment> assignments = pointers.entrySet().stream().map(entry -> new ExpressionAndValuePointers.Assignment(new Symbol((Type)UnknownType.UNKNOWN, (String)entry.getKey()), (ValuePointer)entry.getValue())).toList();
            this.measures.put(outputAlias, new TypedExpressionAndPointers(new ExpressionAndValuePointers(expression, assignments), type));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder frame(WindowNode.Frame frame) {
            this.frame = Optional.of(frame);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rowsPerMatch(RowsPerMatch rowsPerMatch) {
            this.rowsPerMatch = rowsPerMatch;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder skipTo(SkipToPosition position, IrLabel label) {
            this.skipToLabels = ImmutableSet.of((Object)label);
            this.skipToPosition = position;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder skipTo(SkipToPosition position) {
            this.skipToPosition = position;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder seek() {
            this.initial = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder pattern(IrRowPattern pattern) {
            this.pattern = pattern;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSubset(IrLabel name, Set<IrLabel> elements) {
            this.subsets.put(name, elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addVariableDefinition(IrLabel name, Expression expression) {
            this.variableDefinitions.put(name, new ExpressionAndValuePointers(expression, (List)ImmutableList.of()));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addVariableDefinition(IrLabel name, Expression expression, Map<String, ValuePointer> pointers) {
            List<ExpressionAndValuePointers.Assignment> assignments = pointers.entrySet().stream().map(entry -> new ExpressionAndValuePointers.Assignment(new Symbol((Type)BooleanType.BOOLEAN, (String)entry.getKey()), (ValuePointer)entry.getValue())).toList();
            this.variableDefinitions.put(name, new ExpressionAndValuePointers(expression, assignments));
            return this;
        }

        public PlanMatchPattern build() {
            PlanMatchPattern result = PlanMatchPattern.node(PatternRecognitionNode.class, this.source).with(new PatternRecognitionMatcher(this.specification, this.frame, this.rowsPerMatch, this.skipToLabels, this.skipToPosition, this.initial, this.pattern, this.variableDefinitions));
            this.windowFunctionMatchers.forEach(result::with);
            this.measures.entrySet().stream().map(entry -> {
                String name = (String)entry.getKey();
                TypedExpressionAndPointers value = (TypedExpressionAndPointers)entry.getValue();
                return new AliasMatcher(Optional.of(name), new MeasureMatcher(value.expression(), this.subsets, value.type()));
            }).forEach(result::with);
            return result;
        }
    }
}

