/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.assertions.PlanFragmentMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class SubPlanMatcher {
    private final PlanFragmentMatcher fragmentMatcher;
    private final List<SubPlanMatcher> children;

    public static Builder builder() {
        return new Builder();
    }

    public SubPlanMatcher(PlanFragmentMatcher fragmentMatcher, List<SubPlanMatcher> children) {
        this.fragmentMatcher = Objects.requireNonNull(fragmentMatcher, "fragmentMatcher is null");
        this.children = Objects.requireNonNull(children, "children is null");
    }

    public boolean matches(SubPlan subPlan, StatsCalculator statsCalculator, Session session, Metadata metadata) {
        if (subPlan.getChildren().size() != this.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).matches((SubPlan)subPlan.getChildren().get(i), statsCalculator, session, metadata)) continue;
            return false;
        }
        return this.fragmentMatcher.matches(subPlan.getFragment(), statsCalculator, session, metadata);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fragmentMatcher.toString()).append("\n");
        for (SubPlanMatcher child : this.children) {
            builder.append(child.toString());
        }
        return builder.toString();
    }

    public static class Builder {
        private PlanFragmentMatcher fragmentMatcher;
        private List<SubPlanMatcher> children = ImmutableList.of();

        public Builder fragmentMatcher(Function<PlanFragmentMatcher.Builder, PlanFragmentMatcher.Builder> fragmentBuilder) {
            this.fragmentMatcher = fragmentBuilder.apply(PlanFragmentMatcher.builder()).build();
            return this;
        }

        @SafeVarargs
        public final Builder children(Function<Builder, Builder> ... children) {
            this.children = (List)Arrays.stream(children).map(child -> ((Builder)child.apply(new Builder())).build()).collect(ImmutableList.toImmutableList());
            return this;
        }

        public SubPlanMatcher build() {
            return new SubPlanMatcher(this.fragmentMatcher, this.children);
        }
    }
}

