/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

final class Util {
    private Util() {
    }

    static boolean domainsMatch(TupleDomain<Predicate<ColumnHandle>> expected, TupleDomain<ColumnHandle> actual) {
        Optional expectedDomains = expected.getDomains();
        Optional actualDomains = actual.getDomains();
        if (expectedDomains.isPresent() != actualDomains.isPresent()) {
            return false;
        }
        if (expectedDomains.isPresent()) {
            if (((Map)expectedDomains.get()).size() != ((Map)actualDomains.get()).size()) {
                return false;
            }
            for (Map.Entry entry : ((Map)expectedDomains.get()).entrySet()) {
                ColumnHandle actualColumn = (ColumnHandle)Iterables.getOnlyElement((Iterable)((Iterable)((Map)actualDomains.get()).keySet().stream().filter(x -> ((Predicate)entry.getKey()).test(x)).collect(ImmutableList.toImmutableList())));
                if (((Domain)((Map)actualDomains.get()).get(actualColumn)).contains((Domain)entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    static boolean orderingSchemeMatches(List<PlanMatchPattern.Ordering> expectedOrderBy, OrderingScheme orderingScheme, SymbolAliases symbolAliases) {
        if (expectedOrderBy.size() != orderingScheme.orderBy().size()) {
            return false;
        }
        for (int i = 0; i < expectedOrderBy.size(); ++i) {
            PlanMatchPattern.Ordering ordering = expectedOrderBy.get(i);
            Symbol symbol = Symbol.from((Expression)symbolAliases.get(ordering.getField()));
            if (!symbol.equals(orderingScheme.orderBy().get(i))) {
                return false;
            }
            if (ordering.getSortOrder() == orderingScheme.ordering(symbol)) continue;
            return false;
        }
        return true;
    }
}

